/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.openLayers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.js.Window;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.mozilla.javascript.EcmaError;
import org.openstreetmap.josm.plugins.openLayers.CacheableUserAgentContext;
import org.openstreetmap.josm.plugins.openLayers.MyHtmlBlockPanel;

public class Browser
extends HtmlPanel {
    protected static final Logger logger = Logger.getLogger(Browser.class.getName());
    private final SimpleHtmlRendererContext rcontext;
    Dimension oldSize = null;
    MyHtmlBlockPanel.ViewUpdateListener view_update_listener;

    public Browser(String uri, MyHtmlBlockPanel.ViewUpdateListener vul) {
        this.view_update_listener = vul;
        CacheableUserAgentContext ucontext = new CacheableUserAgentContext();
        this.rcontext = new SimpleHtmlRendererContext((HtmlPanel)this, ucontext);
        this.addNotify();
        this.process(uri);
    }

    private void process(String uri) {
        try {
            URL url;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException mfu) {
                int idx = uri.indexOf(58);
                if (idx == -1 || idx == 1) {
                    url = new URL("file:" + uri);
                }
                throw mfu;
            }
            this.rcontext.navigate(url, null);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void setSize(Dimension newSize) {
        if (!newSize.equals(this.oldSize)) {
            this.oldSize = newSize;
            super.setSize(newSize);
            this.validate();
            this.executeAsyncScript("resizeMap(" + newSize.width + "," + newSize.height + ");");
        }
    }

    public void executeAsyncScript(final String script) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Browser.this.executeScript(script);
            }
        });
    }

    public Object executeScript(String script) {
        System.out.println("Executing script " + script);
        try {
            Window window = Window.getWindow(this.rcontext);
            if (window.getDocumentNode() == null) {
                return null;
            }
            return window.eval(script);
        }
        catch (EcmaError ecmaError) {
            logger.log(Level.WARNING, "Javascript error at " + ecmaError.sourceName() + ":" + ecmaError.lineNumber() + ": " + ecmaError.getMessage());
        }
        catch (Throwable err) {
            logger.log(Level.WARNING, "Unable to evaluate Javascript code", err);
        }
        return null;
    }

    protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        return new MyHtmlBlockPanel(Color.WHITE, true, ucontext, rcontext, this, this.view_update_listener);
    }

    public String getStatus() {
        return "Tile loaded";
    }

    static {
        Logger.getLogger("org.lobobrowser").setLevel(Level.WARNING);
    }
}

