/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LfuMemoryStore
extends MemoryStore {
    private static final Log LOG = LogFactory.getLog(LfuMemoryStore.class.getName());

    protected LfuMemoryStore(Ehcache cache, Store diskStore) {
        super(cache, diskStore);
        this.map = new HashMap();
    }

    public final synchronized void doPut(Element elementJustAdded) {
        if (this.isFull()) {
            this.removeLfuElement(elementJustAdded);
        }
    }

    private void removeLfuElement(Element elementJustAdded) {
        Element element;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache is full. Removing LFU element ...");
        }
        if ((element = this.findRelativelyUnused(elementJustAdded)).isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.evict(element);
        this.remove(element.getObjectKey());
    }

    final Element findRelativelyUnused(Element elementJustAdded) {
        LfuPolicy.Metadata[] elements = this.sampleElements(this.map.size());
        LfuPolicy.Metadata metadata = LfuPolicy.leastHit(elements, new ElementMetadata(elementJustAdded));
        return (Element)this.map.get(metadata.getObjectKey());
    }

    LfuPolicy.Metadata[] sampleElements(int size) {
        int[] offsets = LfuPolicy.generateRandomSample(size);
        LfuPolicy.Metadata[] elements = new ElementMetadata[offsets.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < offsets.length; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                iterator.next();
            }
            elements[i] = new ElementMetadata((Element)iterator.next());
        }
        return elements;
    }

    private class ElementMetadata
    implements LfuPolicy.Metadata {
        private Element element;

        public ElementMetadata(Element element) {
            this.element = element;
        }

        public Object getObjectKey() {
            return this.element.getObjectKey();
        }

        public long getHitCount() {
            return this.element.getHitCount();
        }

        public int hashCode() {
            if (this.element != null) {
                return this.element.getKey().hashCode();
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof LfuPolicy.Metadata) {
                LfuPolicy.Metadata metadata = (LfuPolicy.Metadata)object;
                return this.getObjectKey().equals(metadata.getObjectKey());
            }
            return false;
        }
    }
}

