/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.ehcache.distribution.CachePeer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class PayloadUtil {
    public static final int MTU = 1500;
    public static final String URL_DELIMITER = "|";
    private static final Log LOG = LogFactory.getLog(PayloadUtil.class.getName());

    private PayloadUtil() {
    }

    public static byte[] assembleUrlList(List localCachePeers) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < localCachePeers.size(); ++i) {
            CachePeer cachePeer = (CachePeer)localCachePeers.get(i);
            String rmiUrl = null;
            try {
                rmiUrl = cachePeer.getUrl();
            }
            catch (RemoteException e) {
                LOG.error("This should never be thrown as it is called locally");
            }
            if (i != localCachePeers.size() - 1) {
                sb.append(rmiUrl).append(URL_DELIMITER);
                continue;
            }
            sb.append(rmiUrl);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache peers for this CacheManager to be advertised: " + sb);
        }
        return sb.toString().getBytes();
    }

    public static byte[] gzip(byte[] ungzipped) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
            gzipOutputStream.write(ungzipped);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            LOG.fatal("Could not gzip " + ungzipped);
        }
        return bytes.toByteArray();
    }

    public static byte[] ungzip(byte[] gzipped) {
        byte[] ungzipped = new byte[]{};
        try {
            GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(gzipped));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(gzipped.length);
            byte[] buffer = new byte[1500];
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = inputStream.read(buffer, 0, 1500);
                if (bytesRead == -1) continue;
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            ungzipped = byteArrayOutputStream.toByteArray();
            inputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            LOG.fatal("Could not ungzip. Heartbeat will not be working. " + e.getMessage());
        }
        return ungzipped;
    }
}

