/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.openLayers;

import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.openstreetmap.josm.plugins.openLayers.HttpResponse;

public class StorageManager {
    private Cache cache;
    private static StorageManager storage;

    public static void initStorage(String basedir) {
        if (storage != null) {
            storage.dispose();
        }
        storage = new StorageManager(basedir);
    }

    protected StorageManager(String basedir) {
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        this.cache = new Cache("OpenLayers", 500, MemoryStoreEvictionPolicy.LRU, true, basedir + "cache", false, 50400L, 300L, true, 604800L, null);
        CacheManager.getInstance().addCache(this.cache);
    }

    protected void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
        }
    }

    public static StorageManager getInstance() {
        return storage;
    }

    public HttpResponse get(URL key) {
        Element element = this.cache.get(key);
        if (element != null) {
            return (HttpResponse)element.getObjectValue();
        }
        return null;
    }

    public void put(URL key, HttpResponse value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    public static void flush() {
        if (storage != null) {
            StorageManager.storage.cache.flush();
        }
    }
}

