/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.management.Cache;
import net.sf.ehcache.management.CacheConfiguration;
import net.sf.ehcache.management.CacheManager;
import net.sf.ehcache.management.CacheStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ManagementService
implements CacheManagerEventListener {
    private static final Log LOG = LogFactory.getLog(ManagementService.class.getName());
    private MBeanServer mBeanServer;
    private net.sf.ehcache.CacheManager backingCacheManager;
    private boolean registerCacheManager;
    private boolean registerCaches;
    private boolean registerCacheConfigurations;
    private boolean registerCacheStatistics;
    private Status status;

    private ManagementService() {
    }

    public static void registerMBeans(net.sf.ehcache.CacheManager cacheManager, MBeanServer mBeanServer, boolean registerCacheManager, boolean registerCaches, boolean registerCacheConfigurations, boolean registerCacheStatistics) throws CacheException {
        ManagementService registry = new ManagementService();
        registry.status = Status.STATUS_UNINITIALISED;
        registry.backingCacheManager = cacheManager;
        registry.mBeanServer = mBeanServer;
        registry.registerCacheManager = registerCacheManager;
        registry.registerCaches = registerCaches;
        registry.registerCacheConfigurations = registerCacheConfigurations;
        registry.registerCacheStatistics = registerCacheStatistics;
        registry.init();
    }

    public void init() throws CacheException {
        CacheManager cacheManager = new CacheManager(this.backingCacheManager);
        try {
            this.registerCacheManager(cacheManager);
            List caches = cacheManager.getCaches();
            for (int i = 0; i < caches.size(); ++i) {
                Cache cache = (Cache)caches.get(i);
                this.registerCachesIfRequired(cache);
                this.registerCacheStatisticsIfRequired(cache);
                this.registerCacheConfigurationIfRequired(cache);
            }
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.status = Status.STATUS_ALIVE;
        this.backingCacheManager.getCacheManagerEventListenerRegistry().registerListener(this);
    }

    private void registerCacheManager(CacheManager cacheManager) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.registerCacheManager) {
            this.mBeanServer.registerMBean(cacheManager, cacheManager.getObjectName());
        }
    }

    private void registerCacheConfigurationIfRequired(Cache cache) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.registerCacheConfigurations) {
            CacheConfiguration cacheConfiguration = cache.getCacheConfiguration();
            this.mBeanServer.registerMBean(cacheConfiguration, cacheConfiguration.getObjectName());
        }
    }

    private void registerCacheStatisticsIfRequired(Cache cache) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.registerCacheStatistics) {
            CacheStatistics cacheStatistics = cache.getStatistics();
            this.mBeanServer.registerMBean(cacheStatistics, cacheStatistics.getObjectName());
        }
    }

    private void registerCachesIfRequired(Cache cache) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.registerCaches) {
            this.mBeanServer.registerMBean(cache, cache.getObjectName());
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void dispose() throws CacheException {
        Set<ObjectName> registeredObjectNames = null;
        try {
            registeredObjectNames = this.mBeanServer.queryNames(CacheManager.createObjectName(this.backingCacheManager), null);
            registeredObjectNames.addAll(this.mBeanServer.queryNames(new ObjectName("net.sf.ehcache:*,CacheManager=" + this.backingCacheManager.toString()), null));
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Error querying MBeanServer. Error was " + e.getMessage(), e);
        }
        Iterator<ObjectName> iterator = registeredObjectNames.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = iterator.next();
            try {
                this.mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                LOG.error("Error unregistering object instance " + objectName + " . Error was " + e.getMessage(), e);
            }
        }
        this.status = Status.STATUS_SHUTDOWN;
    }

    public void notifyCacheAdded(String cacheName) {
        if (this.registerCaches || this.registerCacheStatistics || this.registerCacheConfigurations) {
            Cache cache = new Cache(this.backingCacheManager.getCache(cacheName));
            try {
                this.registerCachesIfRequired(cache);
                this.registerCacheStatisticsIfRequired(cache);
                this.registerCacheConfigurationIfRequired(cache);
            }
            catch (Exception e) {
                LOG.error("Error registering cache for management for " + cache.getObjectName() + " . Error was " + e.getMessage(), e);
            }
        }
    }

    public void notifyCacheRemoved(String cacheName) {
        ObjectName objectName = null;
        try {
            if (this.registerCaches) {
                objectName = Cache.createObjectName(this.backingCacheManager.toString(), cacheName);
                this.mBeanServer.unregisterMBean(objectName);
            }
            if (this.registerCacheConfigurations) {
                objectName = CacheConfiguration.createObjectName(this.backingCacheManager.toString(), cacheName);
                this.mBeanServer.unregisterMBean(objectName);
            }
            if (this.registerCacheStatistics) {
                objectName = CacheStatistics.createObjectName(this.backingCacheManager.toString(), cacheName);
                this.mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            LOG.error("Error unregistering cache for management for " + objectName + " . Error was " + e.getMessage(), e);
        }
    }
}

