/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Util;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossingWays
extends Test {
    protected static int CROSSING_WAYS = 601;
    Map<Point2D, List<ExtendedSegment>> cellSegments;
    HashSet<WaySegment> errorSegments;
    Map<List<Way>, List<WaySegment>> ways_seen;

    public CrossingWays() {
        super(I18n.tr((String)"Crossing ways."), I18n.tr((String)"This test checks if two roads, railways or waterways crosses in the same layer, but are not connected by a node."));
    }

    @Override
    public void startTest() {
        this.cellSegments = new HashMap<Point2D, List<ExtendedSegment>>(1000);
        this.errorSegments = new HashSet();
        this.ways_seen = new HashMap<List<Way>, List<WaySegment>>(50);
    }

    @Override
    public void endTest() {
        this.cellSegments = null;
        this.errorSegments = null;
        this.ways_seen = null;
    }

    @Override
    public void visit(Way w) {
        boolean isSubway1;
        if (w.deleted || w.incomplete) {
            return;
        }
        String coastline1 = w.get("natural");
        boolean isCoastline1 = coastline1 != null && (coastline1.equals("water") || coastline1.equals("coastline"));
        String railway1 = w.get("railway");
        boolean bl = isSubway1 = railway1 != null && railway1.equals("subway");
        if (w.get("highway") == null && w.get("waterway") == null && (railway1 == null || isSubway1) && !isCoastline1) {
            return;
        }
        String layer1 = w.get("layer");
        int nodesSize = w.nodes.size();
        for (int i = 0; i < nodesSize - 1; ++i) {
            WaySegment ws = new WaySegment(w, i);
            ExtendedSegment es1 = new ExtendedSegment(ws, layer1, railway1, coastline1);
            List<List<ExtendedSegment>> cellSegments = this.getSegments(es1.n1, es1.n2);
            for (List<ExtendedSegment> segments : cellSegments) {
                for (ExtendedSegment es2 : segments) {
                    boolean isCoastline2;
                    if (this.errorSegments.contains(ws) && this.errorSegments.contains(es2.ws)) continue;
                    String layer2 = es2.layer;
                    String railway2 = es2.railway;
                    String coastline2 = es2.coastline;
                    if (layer1 != null ? !layer1.equals(layer2) : layer2 != null) continue;
                    if (!es1.intersects(es2) || isSubway1 && "subway".equals(railway2)) continue;
                    boolean bl2 = isCoastline2 = coastline2 != null && (coastline2.equals("water") || coastline2.equals("coastline"));
                    if (isCoastline1 != isCoastline2) continue;
                    List<Way> prims = Arrays.asList(es1.ws.way, es2.ws.way);
                    List<WaySegment> highlight = this.ways_seen.get(prims);
                    if (highlight == null) {
                        highlight = new ArrayList<WaySegment>();
                        highlight.add(es1.ws);
                        highlight.add(es2.ws);
                        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Crossing ways"), CROSSING_WAYS, prims, highlight));
                        this.ways_seen.put(prims, highlight);
                        continue;
                    }
                    highlight.add(es1.ws);
                    highlight.add(es2.ws);
                }
                segments.add(es1);
            }
        }
    }

    public List<List<ExtendedSegment>> getSegments(Node n1, Node n2) {
        ArrayList<List<ExtendedSegment>> cells = new ArrayList<List<ExtendedSegment>>();
        for (Point2D cell : Util.getSegmentCells(n1, n2, OSMValidatorPlugin.griddetail)) {
            List<ExtendedSegment> segments = this.cellSegments.get(cell);
            if (segments == null) {
                segments = new ArrayList<ExtendedSegment>();
                this.cellSegments.put(cell, segments);
            }
            cells.add(segments);
        }
        return cells;
    }

    private class ExtendedSegment {
        public Node n1;
        public Node n2;
        public WaySegment ws;
        public String layer;
        public String railway;
        public String coastline;

        public ExtendedSegment(WaySegment ws, String layer, String railway, String coastline) {
            this.ws = ws;
            this.n1 = (Node)ws.way.nodes.get(ws.lowerIndex);
            this.n2 = (Node)ws.way.nodes.get(ws.lowerIndex + 1);
            this.layer = layer;
            this.railway = railway;
            this.coastline = coastline;
        }

        public boolean intersects(ExtendedSegment s2) {
            if (this.n1.equals((Object)s2.n1) || this.n2.equals((Object)s2.n2) || this.n1.equals((Object)s2.n2) || this.n2.equals((Object)s2.n1)) {
                return false;
            }
            return Line2D.linesIntersect(this.n1.eastNorth.east(), this.n1.eastNorth.north(), this.n2.eastNorth.east(), this.n2.eastNorth.north(), s2.n1.eastNorth.east(), s2.n1.eastNorth.north(), s2.n2.eastNorth.east(), s2.n2.eastNorth.north());
        }
    }
}

