/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.jrt.core.RoutingGraph;
import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class RoutingMenu
extends JMenu {
    private static final long serialVersionUID = 3559922048225708480L;

    public RoutingMenu(String name) {
        super(name);
        final RoutingLayer routingLayer = RoutingPlugin.getInstance().getRoutingLayer();
        final RoutingModel routingModel = routingLayer.getRoutingModel();
        JMenuItem mi = new JMenuItem(I18n.tr((String)"Start routing"));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!routingLayer.isLayerAdded()) {
                    routingLayer.setLayerAdded();
                    Main.main.addLayer((Layer)routingLayer);
                }
            }
        });
        this.add(mi);
        this.addSeparator();
        ButtonGroup group = new ButtonGroup();
        JMenu m = new JMenu(I18n.tr((String)"Criteria"));
        JRadioButtonMenuItem rshorter = new JRadioButtonMenuItem(I18n.tr((String)"Shortest"));
        rshorter.setSelected(true);
        rshorter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    routingModel.routingGraph.setTypeRoute(RoutingGraph.RouteType.SHORTEST);
                } else {
                    routingModel.routingGraph.setTypeRoute(RoutingGraph.RouteType.FASTEST);
                }
                routingModel.routingGraph.resetGraph();
                routingModel.routingGraph.createGraph();
                routingModel.setNodesChanged();
                Main.map.repaint();
            }
        });
        JRadioButtonMenuItem rfaster = new JRadioButtonMenuItem(I18n.tr((String)"Fastest"));
        group.add(rshorter);
        group.add(rfaster);
        m.add(rshorter);
        m.add(rfaster);
        m.addSeparator();
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Ignore oneways");
        cbmi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    routingModel.routingGraph.getRoutingProfile().setOnewayUse(false);
                } else {
                    routingModel.routingGraph.getRoutingProfile().setOnewayUse(true);
                }
                routingModel.setNodesChanged();
                Main.map.repaint();
            }
        });
        m.add(cbmi);
        this.add(m);
        this.addSeparator();
        mi = new JMenuItem(I18n.tr((String)"Reverse route"));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                routingModel.reverseNodes();
                Main.map.repaint();
            }
        });
        this.add(mi);
        mi = new JMenuItem(I18n.tr((String)"Clear route"));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                routingModel.reset();
                RoutingPlugin.getInstance().getRoutingDialog().clearNodes();
                Main.map.repaint();
            }
        });
        this.add(mi);
    }
}

