/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MoveRouteNodeAction
extends MapMode {
    private static final long serialVersionUID = 1L;
    private static final int DRAG_SQR_RADIUS = 100;
    static Logger logger = Logger.getLogger(RoutingLayer.class);
    private RoutingModel routingModel;
    private RoutingLayer routingLayer = RoutingPlugin.getInstance().getRoutingLayer();
    private RoutingDialog routingDialog;
    private int index;

    public MoveRouteNodeAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Routing"), "move", I18n.tr((String)"Click and drag to move route nodes."), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
        this.routingModel = this.routingLayer.getRoutingModel();
        this.routingDialog = RoutingPlugin.getInstance().getRoutingDialog();
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            List<Node> nl = this.routingModel.getSelectedNodes();
            this.index = -1;
            double dmax = 100.0;
            for (int i = 0; i < nl.size(); ++i) {
                Node node = nl.get(i);
                double d = Main.map.mapView.getPoint(node.eastNorth).distanceSq(e.getPoint());
                if (!(d < dmax)) continue;
                dmax = d;
                this.index = i;
            }
            if (this.index >= 0) {
                logger.debug("Moved from node " + nl.get(this.index));
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.index >= 0) {
            this.searchAndReplaceNode(e.getPoint());
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private void searchAndReplaceNode(Point point) {
        Node node = null;
        List wsl = Main.map.mapView.getNearestWaySegments(point);
        for (WaySegment ws : wsl) {
            double d1;
            if (ws.way.get("highway") == null) continue;
            Node node0 = (Node)ws.way.nodes.get(ws.lowerIndex);
            Node node1 = (Node)ws.way.nodes.get(ws.lowerIndex + 1);
            double d0 = Main.map.mapView.getPoint(node0.eastNorth).distanceSq(point);
            if (d0 < (d1 = Main.map.mapView.getPoint(node1.eastNorth).distanceSq(point))) {
                node = node0;
                break;
            }
            node = node1;
            break;
        }
        if (node == null) {
            logger.debug("Didn't found a close node to move to.");
            return;
        }
        logger.debug("Moved to node " + node);
        this.routingModel.removeNode(this.index);
        this.routingDialog.removeNode(this.index);
        this.routingModel.insertNode(this.index, node);
        this.routingDialog.insertNode(this.index, node.id + " [" + node.coor.toDisplayString() + "]");
        Main.map.repaint();
    }
}

