/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.actions.AddRouteNodeAction;
import com.innovant.josm.plugin.routing.actions.MoveRouteNodeAction;
import com.innovant.josm.plugin.routing.actions.RemoveRouteNodeAction;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import com.innovant.josm.plugin.routing.gui.RoutingMenu;
import com.innovant.josm.plugin.routing.gui.RoutingPreferenceDialog;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;

public class RoutingPlugin
extends Plugin
implements Layer.LayerChangeListener {
    static Logger logger = Logger.getLogger(RoutingPlugin.class);
    private RoutingLayer routingLayer;
    private RoutingDialog routingDialog;
    private PreferenceSetting preferenceSettings;
    private AddRouteNodeAction addRouteNodeAction;
    private RemoveRouteNodeAction removeRouteNodeAction;
    private MoveRouteNodeAction moveRouteNodeAction;
    private IconToggleButton addRouteNodeButton;
    private IconToggleButton removeRouteNodeButton;
    private IconToggleButton moveRouteNodeButton;
    private static RoutingPlugin plugin;

    public RoutingPlugin() {
        plugin = this;
        DOMConfigurator.configure("log4j.xml");
        logger.debug("Loading routing plugin...");
        this.preferenceSettings = new RoutingPreferenceDialog();
        this.routingDialog = new RoutingDialog();
        this.routingLayer = new RoutingLayer(I18n.tr((String)"Navigation"));
        Main.main.menu.add((JMenu)new RoutingMenu(I18n.tr((String)"Routing")));
        Layer.listeners.add(this);
        logger.debug("Finished loading plugin");
    }

    public static RoutingPlugin getInstance() {
        return plugin;
    }

    public RoutingLayer getRoutingLayer() {
        return this.routingLayer;
    }

    public RoutingDialog getRoutingDialog() {
        return this.routingDialog;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.addRouteNodeAction = new AddRouteNodeAction(newFrame);
            this.removeRouteNodeAction = new RemoveRouteNodeAction(newFrame);
            this.moveRouteNodeAction = new MoveRouteNodeAction(newFrame);
            this.addRouteNodeButton = new IconToggleButton((Action)((Object)this.addRouteNodeAction));
            this.removeRouteNodeButton = new IconToggleButton((Action)((Object)this.removeRouteNodeAction));
            this.moveRouteNodeButton = new IconToggleButton((Action)((Object)this.moveRouteNodeAction));
            newFrame.addMapMode(this.addRouteNodeButton);
            newFrame.addMapMode(this.removeRouteNodeButton);
            newFrame.addMapMode(this.moveRouteNodeButton);
            newFrame.toolGroup.add((AbstractButton)this.addRouteNodeButton);
            newFrame.toolGroup.add((AbstractButton)this.removeRouteNodeButton);
            newFrame.toolGroup.add((AbstractButton)this.moveRouteNodeButton);
            this.addRouteNodeButton.setVisible(false);
            this.removeRouteNodeButton.setVisible(false);
            this.moveRouteNodeButton.setVisible(false);
            newFrame.addToggleDialog((ToggleDialog)this.routingDialog);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof RoutingLayer) {
            newLayer.name = I18n.tr((String)"Routing") + " [" + Main.map.mapView.getActiveLayer().name + "]";
            this.addRouteNodeButton.setVisible(true);
            this.removeRouteNodeButton.setVisible(true);
            this.moveRouteNodeButton.setVisible(true);
            logger.debug("Added routing layer.");
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof RoutingLayer) {
            this.addRouteNodeButton.setVisible(false);
            this.removeRouteNodeButton.setVisible(false);
            this.moveRouteNodeButton.setVisible(false);
            logger.debug("Removed routing layer.");
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return this.preferenceSettings;
    }
}

