/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RemoveRouteNodeAction
extends MapMode {
    private static final long serialVersionUID = 1L;
    private static final int REMOVE_SQR_RADIUS = 100;
    static Logger logger = Logger.getLogger(RoutingLayer.class);
    private RoutingModel routingModel;
    private RoutingLayer routingLayer = RoutingPlugin.getInstance().getRoutingLayer();
    private RoutingDialog routingDialog;

    public RemoveRouteNodeAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Routing"), "remove", I18n.tr((String)"Remove route nodes"), mapFrame, ImageProvider.getCursor((String)"normal", (String)"delete"));
        this.routingModel = this.routingLayer.getRoutingModel();
        this.routingDialog = RoutingPlugin.getInstance().getRoutingDialog();
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            List<Node> nl = this.routingModel.getSelectedNodes();
            int index = -1;
            double dmax = 100.0;
            for (int i = 0; i < nl.size(); ++i) {
                Node node = nl.get(i);
                double d = Main.map.mapView.getPoint(node.eastNorth).distanceSq(e.getPoint());
                if (!(d < dmax)) continue;
                dmax = d;
                index = i;
            }
            if (index >= 0) {
                logger.debug("Removing node " + nl.get(index));
                this.routingModel.removeNode(index);
                this.routingDialog.removeNode(index);
                Main.map.repaint();
            } else {
                logger.debug("Can't find a node to remove.");
            }
        }
    }
}

