/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddRouteNodeAction
extends MapMode {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(AddRouteNodeAction.class);
    private RoutingModel routingModel;
    private RoutingLayer routingLayer = RoutingPlugin.getInstance().getRoutingLayer();
    private RoutingDialog routingDialog;

    public AddRouteNodeAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Routing"), "add", I18n.tr((String)"Click to add route nodes."), mapFrame, ImageProvider.getCursor((String)"crosshair", null));
        this.routingModel = this.routingLayer.getRoutingModel();
        this.routingDialog = RoutingPlugin.getInstance().getRoutingDialog();
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            Node node = null;
            List wsl = Main.map.mapView.getNearestWaySegments(e.getPoint());
            for (WaySegment ws : wsl) {
                double d1;
                if (ws.way.get("highway") == null) continue;
                Node node0 = (Node)ws.way.nodes.get(ws.lowerIndex);
                Node node1 = (Node)ws.way.nodes.get(ws.lowerIndex + 1);
                double d0 = Main.map.mapView.getPoint(node0.eastNorth).distanceSq(e.getPoint());
                if (d0 < (d1 = Main.map.mapView.getPoint(node1.eastNorth).distanceSq(e.getPoint()))) {
                    node = node0;
                    break;
                }
                node = node1;
                break;
            }
            logger.debug("selected node " + node);
            if (node == null) {
                logger.debug("no selected node");
                return;
            }
            this.routingModel.addNode(node);
            this.routingDialog.addNode(node.id + " [" + node.coor.toDisplayString() + "]");
        }
        Main.map.repaint();
    }
}

