/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastreInterface;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.EastNorthBound;
import cadastre_fr.SVGParser;
import cadastre_fr.SimplifyWay;
import cadastre_fr.WMSLayer;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadSVGBuilding
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private CadastreGrabber grabber = CadastrePlugin.cadastreGrabber;
    private CadastreInterface wmsInterface;
    private String svg = null;
    private static EastNorthBound currentView = null;
    private EastNorthBound viewBox = null;

    public DownloadSVGBuilding(WMSLayer wmsLayer) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.name}));
        this.wmsLayer = wmsLayer;
        this.wmsInterface = this.grabber.getWmsInterface();
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        try {
            if (this.wmsInterface.retrieveInterface(this.wmsLayer)) {
                this.svg = this.grabBoundary(currentView);
                if (this.svg == null) {
                    return;
                }
                this.getViewBox(this.svg);
                if (this.viewBox == null) {
                    return;
                }
                this.createBuildings(this.svg);
            }
        }
        catch (DuplicateLayerException e) {
            System.err.println("removed a duplicated layer");
        }
    }

    protected void cancel() {
        this.grabber.getWmsInterface().cancel();
    }

    protected void finish() {
    }

    private boolean getViewBox(String svg) {
        double[] box = new SVGParser().getViewBox(svg);
        if (box != null) {
            this.viewBox = new EastNorthBound(new EastNorth(box[0], box[1]), new EastNorth(box[0] + box[2], box[1] + box[3]));
            return true;
        }
        System.out.println("Unable to parse SVG data (viewBox)");
        return false;
    }

    private void createBuildings(String svg) {
        String[] SVGpaths = new SVGParser().getClosedPaths(svg);
        ArrayList<ArrayList<EastNorth>> eastNorths = new ArrayList<ArrayList<EastNorth>>();
        for (int i = 0; i < SVGpaths.length; ++i) {
            ArrayList<EastNorth> eastNorth = new ArrayList<EastNorth>();
            this.createNodes(SVGpaths[i], eastNorth);
            if (eastNorth.size() <= 2) continue;
            eastNorths.add(eastNorth);
        }
        DataSet svgDataSet = new DataSet();
        for (ArrayList arrayList : eastNorths) {
            Way wayToAdd = new Way();
            for (EastNorth eastNorth : arrayList) {
                Node nodeToAdd = new Node(Main.proj.eastNorth2latlon(eastNorth));
                Node nearestNewNode = this.checkNearestNode(nodeToAdd, svgDataSet.nodes);
                if (nearestNewNode == nodeToAdd) {
                    svgDataSet.addPrimitive((OsmPrimitive)nearestNewNode);
                }
                wayToAdd.nodes.add(nearestNewNode);
            }
            wayToAdd.nodes.add(wayToAdd.nodes.get(0));
            svgDataSet.addPrimitive((OsmPrimitive)wayToAdd);
        }
        for (Way way : svgDataSet.ways) {
            new SimplifyWay().simplifyWay(way, svgDataSet, 0.5);
        }
        for (Node node : svgDataSet.nodes) {
            Node nearestNewNode = this.checkNearestNode(node, Main.ds.nodes);
            if (nearestNewNode == node) continue;
            for (Way w : svgDataSet.ways) {
                int replaced = 0;
                for (Node node2 : w.nodes) {
                    if (node2 != node) continue;
                    node2 = nearestNewNode;
                    ++replaced;
                }
                if (w.nodes.size() != replaced) continue;
                w.delete(true);
            }
            node.delete(true);
        }
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        for (Node node : svgDataSet.nodes) {
            if (node.deleted) continue;
            cmds.add(new AddCommand((OsmPrimitive)node));
        }
        for (Way way : svgDataSet.ways) {
            if (way.deleted) continue;
            cmds.add(new AddCommand((OsmPrimitive)way));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create buildings"), cmds));
        Main.map.repaint();
    }

    private void createNodes(String SVGpath, ArrayList<EastNorth> eastNorth) {
        String[] coor = SVGpath.split("[MlZ ]");
        double dx = Double.parseDouble(coor[1]);
        double dy = Double.parseDouble(coor[2]);
        for (int i = 3; i < coor.length; i += 2) {
            if (coor[i].equals("")) {
                eastNorth.clear();
                return;
            }
            double east = dx += Double.parseDouble(coor[i]);
            double north = dy += Double.parseDouble(coor[i + 1]);
            eastNorth.add(new EastNorth(east, north));
        }
        double pivot = this.viewBox.min.getY() + (this.viewBox.max.getY() - this.viewBox.min.getY()) / 2.0;
        for (EastNorth en : eastNorth) {
            en.setLocation(en.east(), 2.0 * pivot - en.north());
        }
    }

    private Node checkNearestNode(Node nodeToAdd, Collection<Node> nodes) {
        double epsilon = 0.05;
        for (Node n : nodes) {
            double dist;
            if (n.deleted || n.incomplete || !((dist = n.eastNorth.distance((Point2D)nodeToAdd.eastNorth)) < epsilon)) continue;
            return n;
        }
        return nodeToAdd;
    }

    private String grabBoundary(EastNorthBound bbox) throws IOException {
        try {
            URL url = null;
            url = this.getURLsvg(bbox);
            System.out.println("grab:" + url);
            return this.grabSVG(url);
        }
        catch (MalformedURLException e) {
            throw (IOException)new IOException(I18n.tr((String)"CadastreGrabber: Illegal url.")).initCause(e);
        }
    }

    private URL getURLsvg(EastNorthBound bbox) throws MalformedURLException {
        String str = new String(this.wmsInterface.baseURL + "/scpc/wms?version=1.1&request=GetMap");
        str = str + "&layers=";
        str = str + "CDIF:LS2";
        str = str + "&format=image/svg";
        str = str + "&bbox=" + bbox.min.east() + ",";
        str = str + bbox.min.north() + ",";
        str = str + bbox.max.east() + ",";
        str = str + bbox.max.north();
        str = str + "&width=800&height=600";
        str = str + "&exception=application/vnd.ogc.se_inimage";
        str = str + "&styles=";
        str = str + "LS2_90";
        System.out.println("URL=" + str);
        return new URL(str.replace(" ", "%20"));
    }

    private String grabSVG(URL url) throws IOException {
        this.wmsInterface.urlConn = (HttpURLConnection)url.openConnection();
        this.wmsInterface.urlConn.setRequestMethod("GET");
        this.wmsInterface.setCookie();
        ProgressInputStream is = new ProgressInputStream((URLConnection)this.wmsInterface.urlConn, Main.pleaseWaitDlg);
        File file = new File(CadastrePlugin.cacheDir + "building.svg");
        String svg = new String();
        try {
            if (file.exists()) {
                file.delete();
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));
            InputStreamReader isr = new InputStreamReader((InputStream)is);
            BufferedReader br = new BufferedReader(isr);
            String line = "";
            while (null != (line = br.readLine())) {
                line = line + "\n";
                bos.write(line.getBytes());
                svg = svg + line;
            }
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        is.close();
        return svg;
    }

    public static void download(WMSLayer wmsLayer) {
        MapView mv = Main.map.mapView;
        currentView = new EastNorthBound(mv.getEastNorth(0, mv.getHeight()), mv.getEastNorth(mv.getWidth(), 0));
        if (DownloadSVGBuilding.currentView.max.east() - DownloadSVGBuilding.currentView.min.east() > 1000.0 || DownloadSVGBuilding.currentView.max.north() - DownloadSVGBuilding.currentView.min.north() > 1000.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"To avoid cadastre WMS overload,\nbuilding import size is limited to 1 km2 max."));
            return;
        }
        if (!CadastrePlugin.autoSourcing) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please, enable auto-sourcing and check cadastre millesime."));
            return;
        }
        Main.worker.execute((Runnable)((Object)new DownloadSVGBuilding(wmsLayer)));
    }
}

