/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheControl;
import cadastre_fr.CadastreGrabber;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.DuplicateLayerException;
import cadastre_fr.WMSLayer;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;

public class DownloadWMSTask
extends PleaseWaitRunnable {
    private WMSLayer wmsLayer;
    private Bounds bounds;
    private CadastreGrabber grabber = CadastrePlugin.cadastreGrabber;

    public DownloadWMSTask(WMSLayer wmsLayer, Bounds bounds) {
        super(I18n.tr((String)"Downloading {0}", (Object[])new Object[]{wmsLayer.name}));
        this.wmsLayer = wmsLayer;
        this.bounds = bounds;
    }

    public void realRun() throws IOException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Contacting WMS Server..."));
        try {
            if (this.grabber.getWmsInterface().retrieveInterface(this.wmsLayer)) {
                if (this.wmsLayer.images.isEmpty()) {
                    if (CacheControl.cacheEnabled && this.wmsLayer.getCacheControl().loadCacheIfExist()) {
                        Main.map.mapView.repaint();
                        return;
                    }
                    if (this.wmsLayer.isRaster()) {
                        this.wmsLayer.setRasterBounds(this.bounds);
                    } else {
                        this.wmsLayer.setCommuneBBox(this.grabber.getWmsInterface().retrieveCommuneBBox());
                    }
                }
                this.wmsLayer.grab(this.grabber, this.bounds);
            }
        }
        catch (DuplicateLayerException e) {
            System.err.println("removed a duplicated layer");
        }
    }

    protected void cancel() {
        this.grabber.getWmsInterface().cancel();
    }

    protected void finish() {
    }

    public static void download(WMSLayer wmsLayer) {
        MapView mv = Main.map.mapView;
        Bounds bounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
        Main.worker.execute((Runnable)((Object)new DownloadWMSTask(wmsLayer, bounds)));
    }
}

