/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;

public abstract class AbstractNode
implements NodeInfo {
    private final List<AbstractNode> children = new ArrayList<AbstractNode>();
    private final TreeInfo treeInfo;

    protected AbstractNode(TreeInfo treeInfo) {
        this.treeInfo = treeInfo;
    }

    public abstract int getTokenType();

    public abstract DetailAST getUnderlyingNode();

    protected List<AbstractNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected void addChild(AbstractNode node) {
        this.children.add(node);
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    @Override
    public boolean hasFingerprint() {
        return false;
    }

    @Override
    public String getURI() {
        return "";
    }

    @Override
    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        AxisIterator axisIterator = this.iterateAxis(axisNumber);
        if (nodeTest != null) {
            axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
        }
        return axisIterator;
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        return this.getLocalPart().compareTo(nodeInfo.getLocalPart());
    }

    @Override
    public final TreeInfo getTreeInfo() {
        return this.treeInfo;
    }

    @Override
    public final NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindings) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final boolean isId() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final boolean isIdref() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final boolean isNilled() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final boolean isStreamed() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final Configuration getConfiguration() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final void setSystemId(String systemId) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final String getSystemId() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final String getPublicId() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final String getBaseURI() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final Location saveLocation() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final int comparePosition(NodeInfo nodeInfo) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final Item head() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final SequenceIterator iterate() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final CharSequence getStringValueCS() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final int getFingerprint() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final String getDisplayName() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final String getPrefix() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final SchemaType getSchemaType() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final AtomicSequence atomize() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final void generateId(FastStringBuffer fastStringBuffer) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    @Override
    public final void copy(Receiver receiver, int index, Location location) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

