/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

@FileStatefulCheck
public final class IllegalTypeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.type";
    private static final String[] DEFAULT_ILLEGAL_TYPES = new String[]{"HashSet", "HashMap", "LinkedHashMap", "LinkedHashSet", "TreeSet", "TreeMap", "java.util.HashSet", "java.util.HashMap", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.TreeSet", "java.util.TreeMap"};
    private static final String[] DEFAULT_IGNORED_METHOD_NAMES = new String[]{"getInitialContext", "getEnvironment"};
    private final Set<String> illegalClassNames = new HashSet<String>();
    private final Set<String> illegalShortClassNames = new HashSet<String>();
    private final Set<String> legalAbstractClassNames = new HashSet<String>();
    private final Set<String> ignoredMethodNames = new HashSet<String>();
    private List<Integer> memberModifiers;
    private Pattern format = Pattern.compile("^(.*[.])?Abstract.*$");
    private boolean validateAbstractClassNames;

    public IllegalTypeCheck() {
        this.setIllegalClassNames(DEFAULT_ILLEGAL_TYPES);
        this.setIgnoredMethodNames(DEFAULT_IGNORED_METHOD_NAMES);
    }

    public void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    public void setValidateAbstractClassNames(boolean validateAbstractClassNames) {
        this.validateAbstractClassNames = validateAbstractClassNames;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21, 9, 30};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.illegalShortClassNames.clear();
        for (String s2 : this.illegalClassNames) {
            if (s2.indexOf(46) != -1) continue;
            this.illegalShortClassNames.add(s2);
        }
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 9: {
                if (!this.isVerifiable(ast)) break;
                this.visitMethodDef(ast);
                break;
            }
            case 10: {
                if (!this.isVerifiable(ast)) break;
                this.visitVariableDef(ast);
                break;
            }
            case 21: {
                this.visitParameterDef(ast);
                break;
            }
            case 30: {
                this.visitImport(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private boolean isVerifiable(DetailAST methodOrVariableDef) {
        boolean result = true;
        if (this.memberModifiers != null) {
            DetailAST modifiersAst = methodOrVariableDef.findFirstToken(5);
            result = this.isContainVerifiableType(modifiersAst);
        }
        return result;
    }

    private boolean isContainVerifiableType(DetailAST modifiers) {
        boolean result = false;
        if (modifiers.getFirstChild() != null) {
            for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
                if (!this.memberModifiers.contains(modifier.getType())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void visitMethodDef(DetailAST methodDef) {
        if (this.isCheckedMethod(methodDef)) {
            this.checkClassName(methodDef);
        }
    }

    private void visitParameterDef(DetailAST parameterDef) {
        DetailAST grandParentAST = parameterDef.getParent().getParent();
        if (grandParentAST.getType() == 9 && this.isCheckedMethod(grandParentAST)) {
            this.checkClassName(parameterDef);
        }
    }

    private void visitVariableDef(DetailAST variableDef) {
        this.checkClassName(variableDef);
    }

    private void visitImport(DetailAST importAst) {
        if (!IllegalTypeCheck.isStarImport(importAst)) {
            String canonicalName = IllegalTypeCheck.getImportedTypeCanonicalName(importAst);
            this.extendIllegalClassNamesWithShortName(canonicalName);
        }
    }

    private static boolean isStarImport(DetailAST importAst) {
        boolean result = false;
        DetailAST toVisit = importAst;
        while (toVisit != null) {
            if ((toVisit = IllegalTypeCheck.getNextSubTreeNode(toVisit, importAst)) == null || toVisit.getType() != 60) continue;
            result = true;
            break;
        }
        return result;
    }

    private void checkClassName(DetailAST ast) {
        DetailAST type = ast.findFirstToken(13);
        FullIdent ident = FullIdent.createFullIdent(type.getFirstChild());
        if (this.isMatchingClassName(ident.getText())) {
            this.log(ident.getLineNo(), ident.getColumnNo(), MSG_KEY, ident.getText());
        }
    }

    private boolean isMatchingClassName(String className) {
        String shortName = className.substring(className.lastIndexOf(46) + 1);
        return this.illegalClassNames.contains(className) || this.illegalShortClassNames.contains(shortName) || this.validateAbstractClassNames && !this.legalAbstractClassNames.contains(className) && this.format.matcher(className).find();
    }

    private void extendIllegalClassNamesWithShortName(String canonicalName) {
        if (this.illegalClassNames.contains(canonicalName)) {
            String shortName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
            this.illegalShortClassNames.add(shortName);
        }
    }

    private static String getImportedTypeCanonicalName(DetailAST importAst) {
        StringBuilder canonicalNameBuilder = new StringBuilder(256);
        DetailAST toVisit = importAst;
        while (toVisit != null) {
            if ((toVisit = IllegalTypeCheck.getNextSubTreeNode(toVisit, importAst)) == null || toVisit.getType() != 58) continue;
            canonicalNameBuilder.append(toVisit.getText());
            DetailAST nextSubTreeNode = IllegalTypeCheck.getNextSubTreeNode(toVisit, importAst);
            if (nextSubTreeNode.getType() == 45) continue;
            canonicalNameBuilder.append('.');
        }
        return canonicalNameBuilder.toString();
    }

    private static DetailAST getNextSubTreeNode(DetailAST currentNodeAst, DetailAST subTreeRootAst) {
        DetailAST currentNode = currentNodeAst;
        DetailAST toVisitAst = currentNode.getFirstChild();
        while (toVisitAst == null) {
            toVisitAst = currentNode.getNextSibling();
            if (toVisitAst != null) continue;
            if (currentNode.getParent().equals(subTreeRootAst)) break;
            currentNode = currentNode.getParent();
        }
        return toVisitAst;
    }

    private boolean isCheckedMethod(DetailAST ast) {
        String methodName = ast.findFirstToken(58).getText();
        return !this.ignoredMethodNames.contains(methodName);
    }

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        Collections.addAll(this.illegalClassNames, classNames);
    }

    public void setIgnoredMethodNames(String ... methodNames) {
        this.ignoredMethodNames.clear();
        Collections.addAll(this.ignoredMethodNames, methodNames);
    }

    public void setLegalAbstractClassNames(String ... classNames) {
        Collections.addAll(this.legalAbstractClassNames, classNames);
    }

    public void setMemberModifiers(String modifiers) {
        ArrayList<Integer> modifiersList = new ArrayList<Integer>();
        for (String modifier : modifiers.split(",")) {
            modifiersList.add(TokenUtil.getTokenId(modifier.trim()));
        }
        this.memberModifiers = modifiersList;
    }
}

