/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.GlobalStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@GlobalStatefulCheck
public class TranslationCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "translation.missingKey";
    public static final String MSG_KEY_MISSING_TRANSLATION_FILE = "translation.missingTranslationFile";
    private static final String TRANSLATION_BUNDLE = "com.puppycrawl.tools.checkstyle.checks.messages";
    private static final String WRONG_LANGUAGE_CODE_KEY = "translation.wrongLanguageCode";
    private static final String DEFAULT_TRANSLATION_REGEXP = "^.+\\..+$";
    private static final Pattern LANGUAGE_COUNTRY_VARIANT_PATTERN = CommonUtil.createPattern("^.+\\_[a-z]{2}\\_[A-Z]{2}\\_[A-Za-z]+\\..+$");
    private static final Pattern LANGUAGE_COUNTRY_PATTERN = CommonUtil.createPattern("^.+\\_[a-z]{2}\\_[A-Z]{2}\\..+$");
    private static final Pattern LANGUAGE_PATTERN = CommonUtil.createPattern("^.+\\_[a-z]{2}\\..+$");
    private static final String DEFAULT_TRANSLATION_FILE_NAME_FORMATTER = "%s.%s";
    private static final String FILE_NAME_WITH_LANGUAGE_CODE_FORMATTER = "%s_%s.%s";
    private static final String REGEXP_FORMAT_TO_CHECK_REQUIRED_TRANSLATIONS = "^%1$s\\_%2$s(\\_[A-Z]{2})?\\.%3$s$|^%1$s\\_%2$s\\_[A-Z]{2}\\_[A-Za-z]+\\.%3$s$";
    private static final String REGEXP_FORMAT_TO_CHECK_DEFAULT_TRANSLATIONS = "^%s\\.%s$";
    private final Log log;
    private final Set<File> filesToProcess = ConcurrentHashMap.newKeySet();
    private Pattern baseName;
    private Set<String> requiredTranslations = new HashSet<String>();

    public TranslationCheck() {
        this.setFileExtensions("properties");
        this.baseName = CommonUtil.createPattern("^messages.*$");
        this.log = LogFactory.getLog(TranslationCheck.class);
    }

    public void setBaseName(Pattern baseName) {
        this.baseName = baseName;
    }

    public void setRequiredTranslations(String ... translationCodes) {
        this.requiredTranslations = Arrays.stream(translationCodes).collect(Collectors.toSet());
        this.validateUserSpecifiedLanguageCodes(this.requiredTranslations);
    }

    private void validateUserSpecifiedLanguageCodes(Set<String> languageCodes) {
        for (String code : languageCodes) {
            if (TranslationCheck.isValidLanguageCode(code)) continue;
            LocalizedMessage msg = new LocalizedMessage(0, TRANSLATION_BUNDLE, WRONG_LANGUAGE_CODE_KEY, new Object[]{code}, this.getId(), this.getClass(), null);
            String exceptionMessage = String.format(Locale.ROOT, "%s [%s]", msg.getMessage(), TranslationCheck.class.getSimpleName());
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    private static boolean isValidLanguageCode(String userSpecifiedLanguageCode) {
        Locale[] locales;
        boolean valid = false;
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            if (!userSpecifiedLanguageCode.equals(locale.toString())) continue;
            valid = true;
            break;
        }
        return valid;
    }

    @Override
    public void beginProcessing(String charset) {
        this.filesToProcess.clear();
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        this.filesToProcess.add(file);
    }

    @Override
    public void finishProcessing() {
        Set<ResourceBundle> bundles = TranslationCheck.groupFilesIntoBundles(this.filesToProcess, this.baseName);
        for (ResourceBundle currentBundle : bundles) {
            this.checkExistenceOfDefaultTranslation(currentBundle);
            this.checkExistenceOfRequiredTranslations(currentBundle);
            this.checkTranslationKeys(currentBundle);
        }
    }

    private void checkExistenceOfDefaultTranslation(ResourceBundle bundle) {
        Optional<String> fileName = TranslationCheck.getMissingFileName(bundle, null);
        if (fileName.isPresent()) {
            this.logMissingTranslation(bundle.getPath(), fileName.get());
        }
    }

    private void checkExistenceOfRequiredTranslations(ResourceBundle bundle) {
        for (String languageCode : this.requiredTranslations) {
            Optional<String> fileName = TranslationCheck.getMissingFileName(bundle, languageCode);
            if (!fileName.isPresent()) continue;
            this.logMissingTranslation(bundle.getPath(), fileName.get());
        }
    }

    private static Optional<String> getMissingFileName(ResourceBundle bundle, String languageCode) {
        String fileNameRegexp;
        boolean searchForDefaultTranslation;
        String extension = bundle.getExtension();
        String baseName = bundle.getBaseName();
        if (languageCode == null) {
            searchForDefaultTranslation = true;
            fileNameRegexp = String.format(Locale.ROOT, REGEXP_FORMAT_TO_CHECK_DEFAULT_TRANSLATIONS, baseName, extension);
        } else {
            searchForDefaultTranslation = false;
            fileNameRegexp = String.format(Locale.ROOT, REGEXP_FORMAT_TO_CHECK_REQUIRED_TRANSLATIONS, baseName, languageCode, extension);
        }
        Optional<String> missingFileName = Optional.empty();
        if (!bundle.containsFile(fileNameRegexp)) {
            missingFileName = searchForDefaultTranslation ? Optional.of(String.format(Locale.ROOT, DEFAULT_TRANSLATION_FILE_NAME_FORMATTER, baseName, extension)) : Optional.of(String.format(Locale.ROOT, FILE_NAME_WITH_LANGUAGE_CODE_FORMATTER, baseName, languageCode, extension));
        }
        return missingFileName;
    }

    private void logMissingTranslation(String filePath, String fileName) {
        MessageDispatcher dispatcher = this.getMessageDispatcher();
        dispatcher.fireFileStarted(filePath);
        this.log(0, MSG_KEY_MISSING_TRANSLATION_FILE, fileName);
        this.fireErrors(filePath);
        dispatcher.fireFileFinished(filePath);
    }

    private static Set<ResourceBundle> groupFilesIntoBundles(Set<File> files, Pattern baseNameRegexp) {
        HashSet<ResourceBundle> resourceBundles = new HashSet<ResourceBundle>();
        for (File currentFile : files) {
            String fileName = currentFile.getName();
            String baseName = TranslationCheck.extractBaseName(fileName);
            Matcher baseNameMatcher = baseNameRegexp.matcher(baseName);
            if (!baseNameMatcher.matches()) continue;
            String extension = CommonUtil.getFileExtension(fileName);
            String path = TranslationCheck.getPath(currentFile.getAbsolutePath());
            ResourceBundle newBundle = new ResourceBundle(baseName, path, extension);
            Optional<ResourceBundle> bundle = TranslationCheck.findBundle(resourceBundles, newBundle);
            if (bundle.isPresent()) {
                bundle.get().addFile(currentFile);
                continue;
            }
            newBundle.addFile(currentFile);
            resourceBundles.add(newBundle);
        }
        return resourceBundles;
    }

    private static Optional<ResourceBundle> findBundle(Set<ResourceBundle> bundles, ResourceBundle targetBundle) {
        Optional<ResourceBundle> result = Optional.empty();
        for (ResourceBundle currentBundle : bundles) {
            if (!targetBundle.getBaseName().equals(currentBundle.getBaseName()) || !targetBundle.getExtension().equals(currentBundle.getExtension()) || !targetBundle.getPath().equals(currentBundle.getPath())) continue;
            result = Optional.of(currentBundle);
            break;
        }
        return result;
    }

    private static String extractBaseName(String fileName) {
        Matcher languageCountryVariantMatcher = LANGUAGE_COUNTRY_VARIANT_PATTERN.matcher(fileName);
        Matcher languageCountryMatcher = LANGUAGE_COUNTRY_PATTERN.matcher(fileName);
        Matcher languageMatcher = LANGUAGE_PATTERN.matcher(fileName);
        String regexp = languageCountryVariantMatcher.matches() ? LANGUAGE_COUNTRY_VARIANT_PATTERN.pattern() : (languageCountryMatcher.matches() ? LANGUAGE_COUNTRY_PATTERN.pattern() : (languageMatcher.matches() ? LANGUAGE_PATTERN.pattern() : DEFAULT_TRANSLATION_REGEXP));
        String removePattern = regexp.substring("^.+".length(), regexp.length());
        return fileName.replaceAll(removePattern, "");
    }

    private static String getPath(String fileNameWithPath) {
        return fileNameWithPath.substring(0, fileNameWithPath.lastIndexOf(File.separator));
    }

    private void checkTranslationKeys(ResourceBundle bundle) {
        Set<File> filesInBundle = bundle.getFiles();
        if (filesInBundle.size() >= 2) {
            HashSet<String> allTranslationKeys = new HashSet<String>();
            HashMap<File, Set<String>> filesAssociatedWithKeys = new HashMap<File, Set<String>>();
            for (File currentFile : filesInBundle) {
                Set<String> keysInCurrentFile = this.getTranslationKeys(currentFile);
                allTranslationKeys.addAll(keysInCurrentFile);
                filesAssociatedWithKeys.put(currentFile, keysInCurrentFile);
            }
            this.checkFilesForConsistencyRegardingTheirKeys(filesAssociatedWithKeys, allTranslationKeys);
        }
    }

    private void checkFilesForConsistencyRegardingTheirKeys(Map<File, Set<String>> fileKeys, Set<String> keysThatMustExist) {
        for (Map.Entry<File, Set<String>> fileKey : fileKeys.entrySet()) {
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = fileKey.getKey().getPath();
            dispatcher.fireFileStarted(path);
            Set<String> currentFileKeys = fileKey.getValue();
            Set missingKeys = keysThatMustExist.stream().filter(key -> !currentFileKeys.contains(key)).collect(Collectors.toSet());
            if (!missingKeys.isEmpty()) {
                for (Object key2 : missingKeys) {
                    this.log(0, MSG_KEY, key2);
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private Set<String> getTranslationKeys(File file) {
        Set<String> keys = new HashSet<String>();
        try (InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Properties translations = new Properties();
            translations.load(inStream);
            keys = translations.stringPropertyNames();
        }
        catch (IOException ex) {
            this.logIoException(ex, file);
        }
        return keys;
    }

    private void logIoException(IOException exception, File file) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(exception instanceof NoSuchFileException)) {
            args = new String[]{exception.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getId(), this.getClass(), null);
        TreeSet<LocalizedMessage> messages = new TreeSet<LocalizedMessage>();
        messages.add(message);
        this.getMessageDispatcher().fireErrors(file.getPath(), messages);
        this.log.debug("IOException occurred.", exception);
    }

    private static class ResourceBundle {
        private final String baseName;
        private final String extension;
        private final String path;
        private final Set<File> files;

        ResourceBundle(String baseName, String path, String extension) {
            this.baseName = baseName;
            this.path = path;
            this.extension = extension;
            this.files = new HashSet<File>();
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public Set<File> getFiles() {
            return Collections.unmodifiableSet(this.files);
        }

        public void addFile(File file) {
            this.files.add(file);
        }

        public boolean containsFile(String fileNameRegexp) {
            boolean containsFile = false;
            for (File currentFile : this.files) {
                if (!Pattern.matches(fileNameRegexp, currentFile.getName())) continue;
                containsFile = true;
                break;
            }
            return containsFile;
        }
    }
}

