/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import javax.annotation.CheckForNull;
import javax.annotation.meta.When;

public abstract class ClassName {
    public static boolean isMathClass(@SlashedClassName String className) {
        return "java/lang/Math".equals(className) || "java/lang/StrictMath".equals(className);
    }

    @DottedClassName
    public static String assertIsDotted(@DottedClassName String className) {
        assert (className.indexOf(47) == -1) : "Not dotted: " + className;
        return className;
    }

    @SlashedClassName
    public static String assertIsSlashed(@SlashedClassName String className) {
        assert (className.indexOf(46) == -1) : "Not slashed: " + className;
        return className;
    }

    public static String toSignature(@SlashedClassName String className) {
        if (className.length() == 0) {
            throw new IllegalArgumentException("classname can't be empty");
        }
        if (className.charAt(0) == '[' || className.endsWith(";")) {
            return className;
        }
        return "L" + className + ";";
    }

    @CheckForNull
    public static String getPrimitiveType(@SlashedClassName String cls) {
        if (!cls.startsWith("java/lang/")) {
            return null;
        }
        if ("Integer".equals(cls = cls.substring(10))) {
            return "I";
        }
        if ("Float".equals(cls)) {
            return "F";
        }
        if ("Double".equals(cls)) {
            return "D";
        }
        if ("Long".equals(cls)) {
            return "J";
        }
        if ("Byte".equals(cls)) {
            return "B";
        }
        if ("Character".equals(cls)) {
            return "C";
        }
        if ("Short".equals(cls)) {
            return "S";
        }
        if ("Boolean".equals(cls)) {
            return "Z";
        }
        return null;
    }

    @CheckForNull
    @SlashedClassName
    public static String fromFieldSignature(String signature) {
        if (signature.charAt(0) != 'L') {
            return null;
        }
        return signature.substring(1, signature.length() - 1);
    }

    @SlashedClassName
    @SuppressFBWarnings(value={"TQ_EXPLICIT_UNKNOWN_SOURCE_VALUE_REACHES_ALWAYS_SINK"})
    public static String toSlashedClassName(@SlashedClassName(when=When.UNKNOWN) String className) {
        if (className.indexOf(46) >= 0) {
            return className.replace('.', '/');
        }
        return className;
    }

    @DottedClassName
    @SuppressFBWarnings(value={"TQ_EXPLICIT_UNKNOWN_SOURCE_VALUE_REACHES_NEVER_SINK"})
    public static String toDottedClassName(@SlashedClassName(when=When.UNKNOWN) String className) {
        if (className.indexOf(47) >= 0) {
            return className.replace('/', '.');
        }
        return className;
    }

    @DottedClassName
    public static String extractPackageName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return className.substring(0, i);
    }

    public static String extractSimpleName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i > 0) {
            className = className.substring(i + 1);
        }
        if ((i = className.lastIndexOf(36)) > 0) {
            className = className.substring(i + 1);
        }
        return className;
    }

    public static boolean isValidClassName(String className) {
        return className.indexOf(40) < 0;
    }

    public static boolean isLocalOrAnonymous(String className) {
        int i = className.lastIndexOf(36);
        if (i >= 0 && i + 1 < className.length()) {
            return Character.isDigit(className.charAt(i + 1));
        }
        return false;
    }

    public static boolean isAnonymous(String className) {
        int i = className.lastIndexOf(36);
        if (i >= 0 && ++i < className.length()) {
            while (i < className.length()) {
                if (!Character.isDigit(className.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @SlashedClassName
    public static String extractClassName(String originalName) {
        String name = originalName;
        if (name.charAt(0) != '[' && name.charAt(name.length() - 1) != ';') {
            return name;
        }
        while (name.charAt(0) == '[') {
            name = name.substring(1);
        }
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        if (name.charAt(0) == '[') {
            throw new IllegalArgumentException("Bad class name: " + originalName);
        }
        return name;
    }

    public static String extractPackagePrefix(String packageName, int count) {
        int prefixLength = 0;
        for (int dotsSeen = 0; dotsSeen < count; ++dotsSeen) {
            int p = packageName.indexOf(46, prefixLength);
            if (p < 0) {
                return packageName;
            }
            prefixLength = p + 1;
        }
        if (prefixLength == 0) {
            return "";
        }
        return packageName.substring(0, prefixLength - 1);
    }

    public static boolean matchedPrefixes(String[] classSearchStrings, @DottedClassName String className) {
        String[] pp = classSearchStrings;
        if (pp == null || pp.length == 0) {
            return true;
        }
        for (String p : pp) {
            if (p.length() <= 0 || className.indexOf(p) < 0) continue;
            return true;
        }
        return false;
    }

    @SlashedClassName
    public static String toSlashedClassName(Class<?> class1) {
        return ClassName.toSlashedClassName(class1.getName());
    }
}

