/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sourceforge.pmd.util.log.PmdLogFormatter;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.XmlLogger;
import org.apache.tools.ant.taskdefs.RecorderEntry;

public class AntLogHandler
extends Handler {
    private Project project;
    private static final Formatter FORMATTER = new PmdLogFormatter();
    private static final Level[] LOG_LEVELS = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINEST};

    public AntLogHandler(Project project) {
        this.project = project;
    }

    public Level getAntLogLevel() {
        for (BuildListener l : this.project.getBuildListeners()) {
            Field declaredField = null;
            try {
                if (l instanceof DefaultLogger) {
                    declaredField = DefaultLogger.class.getDeclaredField("msgOutputLevel");
                } else if (l instanceof XmlLogger) {
                    declaredField = XmlLogger.class.getDeclaredField("msgOutputLevel");
                } else if (l instanceof RecorderEntry) {
                    declaredField = RecorderEntry.class.getDeclaredField("loglevel");
                } else {
                    try {
                        declaredField = l.getClass().getDeclaredField("logLevel");
                    }
                    catch (NoSuchFieldException e) {
                        this.project.log("Unsupported build listener: " + l.getClass(), 4);
                    }
                }
                if (declaredField == null) continue;
                declaredField.setAccessible(true);
                return LOG_LEVELS[declaredField.getInt(l)];
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            }
        }
        this.project.log("Could not determine ant log level, no supported build listeners found. Log level is set to FINEST", 1);
        return Level.FINEST;
    }

    @Override
    public void publish(LogRecord logRecord) {
        int antLevel;
        Level level = logRecord.getLevel();
        if (level == Level.FINEST) {
            antLevel = 4;
        } else if (level == Level.FINE || level == Level.FINER || level == Level.CONFIG) {
            antLevel = 3;
        } else if (level == Level.INFO) {
            antLevel = 2;
        } else if (level == Level.WARNING) {
            antLevel = 1;
        } else if (level == Level.SEVERE) {
            antLevel = 0;
        } else {
            throw new IllegalStateException("Unknown logging level");
        }
        this.project.log(FORMATTER.format(logRecord), antLevel);
        if (logRecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            logRecord.getThrown().printStackTrace(printWriter);
            this.project.log(stringWriter.toString(), antLevel);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }
}

