/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.lang.dfa.report.ReportHTMLPrintVisitor;
import net.sourceforge.pmd.lang.dfa.report.ReportTree;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;

public class YAHTMLRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "yahtml";
    public static final StringProperty OUTPUT_DIR = new StringProperty("outputDir", "Output directory.", null, 0.0f);

    public YAHTMLRenderer() {
        super(NAME, "Yet Another HTML format.");
        this.definePropertyDescriptor(OUTPUT_DIR);
    }

    @Override
    public String defaultFileExtension() {
        return "html";
    }

    @Override
    public void end() throws IOException {
        String outputDir = this.getProperty(OUTPUT_DIR);
        ReportTree tree = this.report.getViolationTree();
        tree.getRootNode().accept(new ReportHTMLPrintVisitor(outputDir == null ? ".." : outputDir));
        this.writer.write("<h3 align=\"center\">The HTML files are located " + (outputDir == null ? "above the project directory" : "in '" + outputDir + '\'') + ".</h3>" + PMD.EOL);
    }
}

