/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.TokenEntry;

public class Match
implements Comparable<Match>,
Iterable<Mark> {
    private int tokenCount;
    private Set<Mark> markSet = new TreeSet<Mark>();
    private String label;
    public static final Comparator<Match> MATCHES_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getMarkCount() - ma.getMarkCount();
        }
    };
    public static final Comparator<Match> LINES_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getLineCount() - ma.getLineCount();
        }
    };
    public static final Comparator<Match> LABEL_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            if (ma.getLabel() == null) {
                return 1;
            }
            if (mb.getLabel() == null) {
                return -1;
            }
            return mb.getLabel().compareTo(ma.getLabel());
        }
    };
    public static final Comparator<Match> LENGTH_COMPARATOR = new Comparator<Match>(){

        @Override
        public int compare(Match ma, Match mb) {
            return mb.getLineCount() - ma.getLineCount();
        }
    };

    public Match(int tokenCount, Mark first, Mark second) {
        this.markSet.add(first);
        this.markSet.add(second);
        this.tokenCount = tokenCount;
    }

    public Match(int tokenCount, TokenEntry first, TokenEntry second) {
        this(tokenCount, new Mark(first), new Mark(second));
    }

    public int getMarkCount() {
        return this.markSet.size();
    }

    public int getLineCount() {
        return this.getMark(0).getLineCount();
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getSourceCodeSlice() {
        return this.getMark(0).getSourceCodeSlice();
    }

    @Override
    public Iterator<Mark> iterator() {
        return this.markSet.iterator();
    }

    @Override
    public int compareTo(Match other) {
        int diff = other.getTokenCount() - this.getTokenCount();
        if (diff != 0) {
            return diff;
        }
        return this.getFirstMark().compareTo(other.getFirstMark());
    }

    public Mark getFirstMark() {
        return this.getMark(0);
    }

    public Mark getSecondMark() {
        return this.getMark(1);
    }

    public String toString() {
        return "Match: " + PMD.EOL + "tokenCount = " + this.tokenCount + PMD.EOL + "marks = " + this.markSet.size();
    }

    public Set<Mark> getMarkSet() {
        return this.markSet;
    }

    public int getEndIndex() {
        return this.getMark(0).getToken().getIndex() + this.getTokenCount() - 1;
    }

    public void setMarkSet(Set<Mark> markSet) {
        this.markSet = markSet;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void addTokenEntry(TokenEntry entry) {
        this.markSet.add(new Mark(entry));
    }

    private Mark getMark(int index) {
        Mark result = null;
        Iterator<Mark> it = this.markSet.iterator();
        for (int i = 0; it.hasNext() && i < index + 1; ++i) {
            result = it.next();
        }
        return result;
    }
}

