/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.RuleViolationComparator;
import net.sourceforge.pmd.ThreadSafeReportListener;
import net.sourceforge.pmd.lang.dfa.report.ReportTree;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.util.DateTimeUtil;
import net.sourceforge.pmd.util.EmptyIterator;
import net.sourceforge.pmd.util.NumericConstants;
import org.apache.commons.lang3.StringUtils;

public class Report
implements Iterable<RuleViolation> {
    private final ReportTree violationTree = new ReportTree();
    private final List<RuleViolation> violations = new ArrayList<RuleViolation>();
    private final Set<Metric> metrics = new HashSet<Metric>();
    private final List<ThreadSafeReportListener> listeners = new ArrayList<ThreadSafeReportListener>();
    private List<ProcessingError> errors;
    private List<ConfigurationError> configErrors;
    private Map<Integer, String> linesToSuppress = new HashMap<Integer, String>();
    private long start;
    private long end;
    private List<SuppressedViolation> suppressedRuleViolations = new ArrayList<SuppressedViolation>();

    public static Report createReport(RuleContext ctx, String fileName) {
        Report report = new Report();
        report.addListeners(ctx.getReport().getListeners());
        ctx.setReport(report);
        ctx.setSourceCodeFilename(fileName);
        ctx.setSourceCodeFile(new File(fileName));
        return report;
    }

    public void suppress(Map<Integer, String> lines) {
        this.linesToSuppress = lines;
    }

    private static String keyFor(RuleViolation rv) {
        return StringUtils.isNotBlank((CharSequence)rv.getPackageName()) ? rv.getPackageName() + '.' + rv.getClassName() : "";
    }

    public Map<String, Integer> getCountSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : this.violationTree) {
            String key;
            Integer o = (Integer)summary.get(key = Report.keyFor(rv));
            summary.put(key, o == null ? NumericConstants.ONE : o + 1);
        }
        return summary;
    }

    public ReportTree getViolationTree() {
        return this.violationTree;
    }

    public Map<String, Integer> getSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : this.violations) {
            String name = rv.getRule().getName();
            if (!summary.containsKey(name)) {
                summary.put(name, NumericConstants.ZERO);
            }
            Integer count = (Integer)summary.get(name);
            summary.put(name, count + 1);
        }
        return summary;
    }

    public void addListener(ThreadSafeReportListener listener) {
        this.listeners.add(listener);
    }

    public List<SuppressedViolation> getSuppressedRuleViolations() {
        return this.suppressedRuleViolations;
    }

    public void addRuleViolation(RuleViolation violation) {
        int line = violation.getBeginLine();
        if (this.linesToSuppress.containsKey(line)) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, true, this.linesToSuppress.get(line)));
            return;
        }
        if (violation.isSuppressed()) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, false, null));
            return;
        }
        int index = Collections.binarySearch(this.violations, violation, RuleViolationComparator.INSTANCE);
        this.violations.add(index < 0 ? -index - 1 : index, violation);
        this.violationTree.addRuleViolation(violation);
        for (ThreadSafeReportListener listener : this.listeners) {
            listener.ruleViolationAdded(violation);
        }
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        for (ThreadSafeReportListener listener : this.listeners) {
            listener.metricAdded(metric);
        }
    }

    public void addConfigError(ConfigurationError error) {
        if (this.configErrors == null) {
            this.configErrors = new ArrayList<ConfigurationError>();
        }
        this.configErrors.add(error);
    }

    public void addError(ProcessingError error) {
        if (this.errors == null) {
            this.errors = new ArrayList<ProcessingError>();
        }
        this.errors.add(error);
    }

    public void merge(Report r) {
        Iterator<ProcessingError> i = r.errors();
        while (i.hasNext()) {
            this.addError(i.next());
        }
        Iterator<ConfigurationError> ce = r.configErrors();
        while (ce.hasNext()) {
            this.addConfigError(ce.next());
        }
        Iterator<Metric> m = r.metrics();
        while (m.hasNext()) {
            this.addMetric(m.next());
        }
        for (RuleViolation violation : r) {
            int index = Collections.binarySearch(this.violations, violation, RuleViolationComparator.INSTANCE);
            this.violations.add(index < 0 ? -index - 1 : index, violation);
            this.violationTree.addRuleViolation(violation);
        }
        Iterator<SuppressedViolation> s = r.getSuppressedRuleViolations().iterator();
        while (s.hasNext()) {
            this.suppressedRuleViolations.add(s.next());
        }
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public Iterator<Metric> metrics() {
        return this.metrics.iterator();
    }

    public boolean isEmpty() {
        return !this.violations.iterator().hasNext() && !this.hasErrors();
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public boolean hasConfigErrors() {
        return this.configErrors != null && !this.configErrors.isEmpty();
    }

    public boolean treeIsEmpty() {
        return !this.violationTree.iterator().hasNext();
    }

    public Iterator<RuleViolation> treeIterator() {
        return this.violationTree.iterator();
    }

    @Override
    public Iterator<RuleViolation> iterator() {
        return this.violations.iterator();
    }

    public Iterator<ProcessingError> errors() {
        return this.errors == null ? EmptyIterator.instance() : this.errors.iterator();
    }

    public Iterator<ConfigurationError> configErrors() {
        return this.configErrors == null ? EmptyIterator.instance() : this.configErrors.iterator();
    }

    public int treeSize() {
        return this.violationTree.size();
    }

    public int size() {
        return this.violations.size();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void end() {
        this.end = System.currentTimeMillis();
    }

    public long getElapsedTimeInMillis() {
        return this.end - this.start;
    }

    public List<ThreadSafeReportListener> getListeners() {
        return this.listeners;
    }

    public void addListeners(List<ThreadSafeReportListener> allListeners) {
        this.listeners.addAll(allListeners);
    }

    public static class SuppressedViolation {
        private final RuleViolation rv;
        private final boolean isNOPMD;
        private final String userMessage;

        public SuppressedViolation(RuleViolation rv, boolean isNOPMD, String userMessage) {
            this.isNOPMD = isNOPMD;
            this.rv = rv;
            this.userMessage = userMessage;
        }

        public boolean suppressedByNOPMD() {
            return this.isNOPMD;
        }

        public boolean suppressedByAnnotation() {
            return !this.isNOPMD;
        }

        public RuleViolation getRuleViolation() {
            return this.rv;
        }

        public String getUserMessage() {
            return this.userMessage;
        }
    }

    public static class ProcessingError {
        private final Throwable error;
        private final String file;

        public ProcessingError(Throwable error, String file) {
            this.error = error;
            this.file = file;
        }

        public String getMsg() {
            return this.error.getMessage();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public String getDetail() {
            try {
                Throwable throwable = null;
                try (StringWriter stringWriter = new StringWriter();){
                    String string;
                    PrintWriter writer = new PrintWriter(stringWriter);
                    Throwable throwable2 = null;
                    try {
                        this.error.printStackTrace(writer);
                        string = stringWriter.toString();
                    }
                    catch (Throwable throwable3) {
                        try {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                ProcessingError.$closeResource(throwable2, writer);
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    ProcessingError.$closeResource(throwable2, writer);
                    return string;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getFile() {
            return this.file;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class ConfigurationError {
        private final Rule rule;
        private final String issue;

        public ConfigurationError(Rule theRule, String theIssue) {
            this.rule = theRule;
            this.issue = theIssue;
        }

        public Rule rule() {
            return this.rule;
        }

        public String issue() {
            return this.issue;
        }
    }

    public static class ReadableDuration {
        private final long duration;

        public ReadableDuration(long duration) {
            this.duration = duration;
        }

        public String getTime() {
            return DateTimeUtil.asHoursMinutesSeconds(this.duration);
        }
    }
}

