/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;

public class ASTTreeCell
extends TreeCell<Node> {
    private final MainDesignerController controller;

    public ASTTreeCell(MainDesignerController controller) {
        this.controller = controller;
    }

    protected void updateItem(Node item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
            return;
        }
        this.setText(item.toString() + (item.getImage() == null ? "" : " \"" + item.getImage() + "\""));
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton() == MouseButton.PRIMARY && ((TreeItem)this.getTreeView().getSelectionModel().getSelectedItem()).getValue() == item) {
                this.controller.onNodeItemSelected(item);
                t.consume();
            }
        });
    }
}

