/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.stage.WindowEvent;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.util.TextAwareNodeWrapper;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.NodeStyleSpan;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlighter;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.model.StyleSpans;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class SyntaxHighlightingCodeArea
extends CodeArea {
    private static final Duration TEXT_CHANGE_DELAY = Duration.ofMillis(30L);
    private final Var<Subscription> syntaxAutoRefresh = Var.newSimpleVar(null);
    private final Var<SyntaxHighlighter> syntaxHighlighter = Var.newSimpleVar(null);
    private final Var<StyleSpans<Collection<String>>> currentSyntaxHighlight = Var.newSimpleVar(null);
    protected final Val<StyleSpans<Collection<String>>> syntaxHighlight = this.currentSyntaxHighlight;

    public SyntaxHighlightingCodeArea() {
        EventHandler autoCloseHandler = e -> this.syntaxAutoRefresh.ifPresent(Subscription::unsubscribe);
        Val.wrap((ObservableValue)this.sceneProperty()).filter(Objects::nonNull).flatMap(Scene::windowProperty).values().filter(Objects::nonNull).subscribe(c -> c.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, autoCloseHandler));
    }

    public void setSyntaxHighlighter(SyntaxHighlighter highlighter) {
        if (Objects.equals(highlighter, this.syntaxHighlighter.getValue())) {
            return;
        }
        this.syntaxHighlighter.ifPresent(previous -> this.getStyleClass().remove((Object)("." + previous.getLanguageTerseName())));
        this.syntaxAutoRefresh.ifPresent(Subscription::unsubscribe);
        if (highlighter == null) {
            this.syntaxAutoRefresh.setValue(null);
            this.setCurrentSyntaxHighlight(null);
            return;
        }
        this.syntaxHighlighter.setValue((Object)highlighter);
        this.getStyleClass().add((Object)("." + highlighter.getLanguageTerseName()));
        this.syntaxAutoRefresh.setValue((Object)this.subscribeSyntaxHighlighting(this.defaultHighlightingTicks(), highlighter));
        try {
            Task<StyleSpans<Collection<String>>> t = SyntaxHighlightingCodeArea.computeHighlightingAsync(Executors.newSingleThreadExecutor(), highlighter, this.getText());
            t.setOnSucceeded(e -> this.setCurrentSyntaxHighlight((StyleSpans<Collection<String>>)((StyleSpans)t.getValue())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Val<Boolean> syntaxHighlightingEnabledProperty() {
        return this.syntaxHighlighter.map(Objects::nonNull);
    }

    private EventStream<?> defaultHighlightingTicks() {
        return this.plainTextChanges().filter(ch -> !ch.isIdentity()).distinct();
    }

    private Subscription subscribeSyntaxHighlighting(EventStream<?> ticks, SyntaxHighlighter highlighter) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return ticks.successionEnds(TEXT_CHANGE_DELAY).supplyTask(() -> SyntaxHighlightingCodeArea.computeHighlightingAsync(executorService, highlighter, this.getText())).awaitLatest(ticks).filterMap(t -> {
            t.ifFailure(Throwable::printStackTrace);
            return t.toOptional();
        }).subscribe(this::setCurrentSyntaxHighlight).and(executorService::shutdownNow);
    }

    private static Task<StyleSpans<Collection<String>>> computeHighlightingAsync(ExecutorService service, final SyntaxHighlighter highlighter, final String text) {
        Task<StyleSpans<Collection<String>>> task = new Task<StyleSpans<Collection<String>>>(){

            protected StyleSpans<Collection<String>> call() {
                return highlighter.computeHighlighting(text);
            }
        };
        if (!service.isShutdown()) {
            service.execute((Runnable)task);
        }
        return task;
    }

    protected void clearSyntaxHighlighting() {
        this.setCurrentSyntaxHighlight(null);
    }

    private void setCurrentSyntaxHighlight(StyleSpans<Collection<String>> newSyntax) {
        Optional oldSyntaxHighlight = this.currentSyntaxHighlight.getOpt();
        this.currentSyntaxHighlight.setValue(newSyntax);
        this.setStyleSpans(0, this.styleSyntaxHighlightChange(oldSyntaxHighlight, newSyntax));
    }

    protected StyleSpans<Collection<String>> styleSyntaxHighlightChange(Optional<StyleSpans<Collection<String>>> oldSyntax, StyleSpans<Collection<String>> newSyntax) {
        return newSyntax;
    }

    protected void updateSyntaxHighlightingSynchronously() {
        this.syntaxHighlighter.getOpt().map(h -> h.computeHighlighting(this.getText())).ifPresent(arg_0 -> this.currentSyntaxHighlight.setValue(arg_0));
    }

    protected StyleSpans<Collection<String>> emptySpan() {
        return StyleSpans.singleton(Collections.emptyList(), (int)this.getLength());
    }

    protected static Collection<String> additiveOverlay(Collection<String> style1, Collection<String> style2) {
        if (style1.isEmpty()) {
            return style2;
        }
        if (style2.isEmpty()) {
            return style1;
        }
        HashSet<String> styles = new HashSet<String>(style1);
        styles.addAll(style2);
        return styles;
    }

    public TextAwareNodeWrapper wrapNode(Node node) {
        return NodeStyleSpan.fromNode(node, this).snapshot();
    }
}

