/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.popups;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;

public class AuxclasspathSetupController
implements Initializable {
    private final DesignerRoot designerRoot;
    @FXML
    private Button removeFileButton;
    @FXML
    private Button selectFilesButton;
    @FXML
    private ListView<File> fileListView = new ListView();
    @FXML
    private Button moveItemUpButton;
    @FXML
    private Button moveItemDownButton;
    @FXML
    private Button setClassPathButton;
    @FXML
    private Button cancelButton;

    public AuxclasspathSetupController(DesignerRoot designerRoot) {
        this.designerRoot = designerRoot;
    }

    public void initialize(URL location, ResourceBundle resources) {
        BooleanBinding noSelection = this.fileListView.getSelectionModel().selectedItemProperty().isNull();
        this.removeFileButton.disableProperty().bind((ObservableValue)noSelection);
        this.moveItemUpButton.disableProperty().bind((ObservableValue)noSelection.or((ObservableBooleanValue)this.fileListView.getSelectionModel().selectedIndexProperty().isEqualTo(0)));
        IntegerBinding lastIndexBinding = Bindings.createIntegerBinding(() -> this.fileListView.getItems().size() - 1, (Observable[])new Observable[]{Val.wrap((ObservableValue)this.fileListView.itemsProperty()).flatMap(LiveList::sizeOf)});
        this.moveItemDownButton.disableProperty().bind((ObservableValue)noSelection.or((ObservableBooleanValue)this.fileListView.getSelectionModel().selectedIndexProperty().isEqualTo((ObservableNumberValue)lastIndexBinding)));
        this.fileListView.setCellFactory(DesignerUtil.simpleListCellFactory(File::getName, File::getAbsolutePath));
        this.selectFilesButton.setOnAction(e -> this.onSelectFileClicked());
        this.removeFileButton.setOnAction(e -> this.onRemoveFileClicked());
        this.moveItemUpButton.setOnAction(e -> this.moveUp());
        this.moveItemDownButton.setOnAction(e -> this.moveDown());
    }

    private void onSelectFileClicked() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Add files to the auxilliary classpath");
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Java archives", new String[]{"*.jar", "*.war", "*.ear"}), new FileChooser.ExtensionFilter("Java class files", new String[]{"*.class"})});
        List files = chooser.showOpenMultipleDialog((Window)this.designerRoot.getMainStage());
        this.fileListView.getItems().addAll((Collection)files);
    }

    private void onRemoveFileClicked() {
        File f = (File)this.fileListView.getSelectionModel().getSelectedItem();
        this.fileListView.getItems().remove((Object)f);
    }

    private void moveUp() {
        this.moveItem(-1);
    }

    private void moveDown() {
        this.moveItem(1);
    }

    private void moveItem(int direction) {
        if (this.fileListView.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        int newIndex = this.fileListView.getSelectionModel().getSelectedIndex() + direction;
        if (newIndex < 0 || newIndex >= this.fileListView.getItems().size()) {
            return;
        }
        File selected = (File)this.fileListView.getSelectionModel().getSelectedItem();
        this.fileListView.getItems().remove((Object)selected);
        this.fileListView.getItems().add(newIndex, (Object)selected);
        this.fileListView.scrollTo(newIndex);
        this.fileListView.getSelectionModel().select(newIndex);
    }

    public void show(Stage parentStage, List<File> currentItems, Consumer<List<File>> onApply) {
        FXMLLoader fxmlLoader = new FXMLLoader(DesignerUtil.getFxml("auxclasspath-setup-popup.fxml"));
        fxmlLoader.setControllerFactory(type -> {
            if (type == AuxclasspathSetupController.class) {
                return this;
            }
            throw new IllegalStateException("Wrong controller!");
        });
        Stage stage = new Stage();
        try {
            stage.setScene(new Scene((Parent)fxmlLoader.load()));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        this.fileListView.setItems(FXCollections.observableArrayList(currentItems));
        stage.setTitle("Auxilliary classpath setup");
        stage.initOwner((Window)parentStage);
        stage.initModality(Modality.WINDOW_MODAL);
        this.setClassPathButton.setOnAction(e -> {
            stage.close();
            onApply.accept((List<File>)this.fileListView.getItems());
        });
        this.cancelButton.setOnAction(e -> stage.close());
        stage.show();
    }
}

