/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluationException;
import net.sourceforge.pmd.util.fxdesigner.util.PropertyDescriptorSpec;
import org.apache.commons.lang3.StringUtils;

public class XPathEvaluator {
    public List<Node> evaluateQuery(Node compilationUnit, LanguageVersion languageVersion, String xpathVersion, String xpathQuery, List<PropertyDescriptorSpec> properties) throws XPathEvaluationException {
        if (StringUtils.isBlank((CharSequence)xpathQuery)) {
            return Collections.emptyList();
        }
        try {
            final ArrayList<Node> results = new ArrayList<Node>();
            XPathRule xpathRule = new XPathRule(){

                public void addViolation(Object data, Node node, String arg) {
                    results.add(node);
                }
            };
            xpathRule.setMessage("");
            xpathRule.setLanguage(languageVersion.getLanguage());
            xpathRule.setXPath(xpathQuery);
            xpathRule.setVersion(xpathVersion);
            properties.stream().map(PropertyDescriptorSpec::build).forEach(arg_0 -> ((XPathRule)xpathRule).definePropertyDescriptor(arg_0));
            RuleSet ruleSet = new RuleSetFactory().createSingleRuleRuleSet((Rule)xpathRule);
            RuleSets ruleSets = new RuleSets(ruleSet);
            RuleContext ruleContext = new RuleContext();
            ruleContext.setLanguageVersion(languageVersion);
            ruleContext.setIgnoreExceptions(false);
            ruleSets.apply(Collections.singletonList(compilationUnit), ruleContext, xpathRule.getLanguage());
            return results;
        }
        catch (RuntimeException e) {
            throw new XPathEvaluationException(e);
        }
    }
}

