/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import org.reactfx.AwaitingEventStream;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.value.Var;

public class EventLogController
implements Initializable {
    private static final Duration PARSE_EXCEPTION_DELAY = Duration.ofMillis(3000L);
    private final DesignerRoot designerRoot;
    private final MainDesignerController mediator;
    @FXML
    private TableView<LogEntry> eventLogTableView;
    @FXML
    private TableColumn<LogEntry, Date> logDateColumn;
    @FXML
    private TableColumn<LogEntry, LogEntry.Category> logCategoryColumn;
    @FXML
    private TableColumn<LogEntry, String> logMessageColumn;
    @FXML
    private TextArea logDetailsTextArea;
    private Var<List<Node>> selectedErrorNodes = Var.newSimpleVar(Collections.emptyList());

    public EventLogController(DesignerRoot owner, MainDesignerController mediator) {
        this.designerRoot = owner;
        this.mediator = mediator;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.logCategoryColumn.setCellValueFactory((Callback)new PropertyValueFactory("category"));
        this.logMessageColumn.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.logDateColumn.setCellValueFactory(entry -> new SimpleObjectProperty((Object)((LogEntry)entry.getValue()).getTimestamp()));
        this.logDateColumn.setCellFactory(column -> new TableCell<LogEntry, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(dateFormat.format(item));
                }
            }
        });
        AwaitingEventStream onlyParseException = this.designerRoot.getLogger().getLog().filter(x -> x.getCategory() == LogEntry.Category.PARSE_EXCEPTION).successionEnds(PARSE_EXCEPTION_DELAY);
        AwaitingEventStream onlyXPathException = this.designerRoot.getLogger().getLog().filter(x -> x.getCategory() == LogEntry.Category.XPATH_EVALUATION_EXCEPTION).successionEnds(PARSE_EXCEPTION_DELAY);
        EventStream otherExceptions = this.designerRoot.getLogger().getLog().filter(x -> x.getCategory() != LogEntry.Category.PARSE_EXCEPTION).filter(y -> y.getCategory() != LogEntry.Category.XPATH_EVALUATION_EXCEPTION);
        EventStreams.merge((EventStream[])new EventStream[]{onlyParseException, otherExceptions, onlyXPathException}).subscribe(t -> this.eventLogTableView.getItems().add(t));
        this.eventLogTableView.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.onExceptionSelectionChanges((LogEntry)oldVal, (LogEntry)newVal));
        EventStreams.combine((EventStream)EventStreams.changesOf((ObservableValue)this.eventLogTableView.focusedProperty()), (EventStream)EventStreams.changesOf(this.selectedErrorNodes));
        EventStreams.valuesOf((ObservableValue)this.eventLogTableView.focusedProperty()).successionEnds(Duration.ofMillis(100L)).subscribe(b -> {
            if (b.booleanValue()) {
                this.mediator.handleSelectedNodeInError((List)this.selectedErrorNodes.getValue());
            } else {
                this.mediator.resetSelectedErrorNodes();
            }
        });
        this.selectedErrorNodes.values().subscribe(this.mediator::handleSelectedNodeInError);
        this.eventLogTableView.resizeColumn(this.logMessageColumn, -1.0);
        this.logMessageColumn.prefWidthProperty().bind((ObservableValue)this.eventLogTableView.widthProperty().subtract(this.logCategoryColumn.getPrefWidth()).subtract(this.logDateColumn.getPrefWidth()).subtract(2));
        this.logDateColumn.setSortType(TableColumn.SortType.DESCENDING);
    }

    private void handleSelectedEntry(LogEntry entry) {
        if (entry == null) {
            this.selectedErrorNodes.setValue(Collections.emptyList());
            return;
        }
        switch (entry.getCategory()) {
            case OTHER: {
                break;
            }
            case PARSE_EXCEPTION: {
                break;
            }
            case TYPERESOLUTION_EXCEPTION: 
            case SYMBOL_FACADE_EXCEPTION: {
                DesignerUtil.stackTraceToXPath(entry.getThrown()).map(this.mediator::runXPathQuery).ifPresent(arg_0 -> this.selectedErrorNodes.setValue(arg_0));
                break;
            }
        }
    }

    private void onExceptionSelectionChanges(LogEntry oldVal, LogEntry newVal) {
        this.logDetailsTextArea.setText(newVal == null ? "" : newVal.getStackTrace());
        if (!Objects.equals(newVal, oldVal)) {
            this.handleSelectedEntry(newVal);
        }
    }
}

