/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.EventLogController;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.NodeInfoPanelController;
import net.sourceforge.pmd.util.fxdesigner.SourceEditorController;
import net.sourceforge.pmd.util.fxdesigner.XPathPanelController;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;

public class Designer
extends Application {
    private void parseParameters(Application.Parameters params) {
        List raw = params.getRaw();
        if (!raw.contains("-v") && !raw.contains("--verbose")) {
            System.err.close();
        }
    }

    public void start(Stage stage) throws IOException {
        this.parseParameters(this.getParameters());
        FXMLLoader loader = new FXMLLoader(DesignerUtil.getFxml("designer.fxml"));
        DesignerRoot owner = new DesignerRoot(stage);
        MainDesignerController mainController = new MainDesignerController(owner);
        NodeInfoPanelController nodeInfoPanelController = new NodeInfoPanelController(mainController);
        XPathPanelController xpathPanelController = new XPathPanelController(owner, mainController);
        SourceEditorController sourceEditorController = new SourceEditorController(owner, mainController);
        EventLogController eventLogController = new EventLogController(owner, mainController);
        loader.setControllerFactory(type -> {
            if (type == MainDesignerController.class) {
                return mainController;
            }
            if (type == NodeInfoPanelController.class) {
                return nodeInfoPanelController;
            }
            if (type == XPathPanelController.class) {
                return xpathPanelController;
            }
            if (type == SourceEditorController.class) {
                return sourceEditorController;
            }
            if (type == EventLogController.class) {
                return eventLogController;
            }
            try {
                return type.newInstance();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new RuntimeException(exc);
            }
        });
        stage.setOnCloseRequest(e -> mainController.shutdown());
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        stage.setTitle("PMD Rule Designer (v " + PMDVersion.VERSION + ')');
        this.setIcons(stage);
        stage.setScene(scene);
        stage.show();
    }

    private void setIcons(Stage primaryStage) {
        ObservableList icons = primaryStage.getIcons();
        String dirPrefix = "icons/app/";
        List<String> imageNames = Arrays.asList("designer_logo.jpeg");
        List images = imageNames.stream().map(s -> "icons/app/" + s).map(s -> ((Object)((Object)this)).getClass().getResourceAsStream((String)s)).filter(Objects::nonNull).map(Image::new).collect(Collectors.toList());
        icons.addAll(images);
    }

    public static void main(String[] args) {
        Designer.launch((String[])args);
    }
}

