/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import org.apache.tools.ant.BuildException;

public class ConvertXmlToTextTask
extends AbstractFindBugsTask {
    private boolean longBugCodes;
    private boolean applySuppression;
    private boolean failIfBugFound;
    private String input;
    private String output;
    private String format = "html";

    public ConvertXmlToTextTask() {
        super("edu.umd.cs.findbugs.PrintingBugReporter");
        this.setFailOnError(true);
    }

    public void setLongBugCodes(boolean longBugCodes) {
        this.longBugCodes = longBugCodes;
    }

    public void setApplySuppression(boolean applySuppression) {
        this.applySuppression = applySuppression;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInputFile(String input) {
        this.input = input;
    }

    public void setOutputFile(String output) {
        this.output = output;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFailIfBugFound(boolean failIfBugFound) {
        this.failIfBugFound = failIfBugFound;
    }

    @Override
    protected void checkParameters() {
        if (this.input == null) {
            throw new BuildException("input attribute is required", this.getLocation());
        }
        if (!("text".equals(this.format) || "html".equals(this.format) || this.format.startsWith("html:"))) {
            throw new BuildException("invalid value " + this.format + " for format attribute", this.getLocation());
        }
    }

    @Override
    protected void configureFindbugsEngine() {
        this.addArg("-exitcode");
        if (this.format.startsWith("html")) {
            this.addArg("-" + this.format);
        }
        if (this.longBugCodes) {
            this.addArg("-longBugCodes");
        }
        if (this.applySuppression) {
            this.addArg("-applySuppression");
        }
        this.addArg(this.input);
        if (this.output != null) {
            this.addArg(this.output);
        }
    }

    @Override
    protected void beforeExecuteJavaProcess() {
        if (this.output != null) {
            this.log("Converting " + this.input + " to " + this.output + " using format " + this.format);
        } else {
            this.log("Converting " + this.input + " using format " + this.format);
        }
    }

    @Override
    protected void afterExecuteJavaProcess(int rc) {
        if (rc == 0) {
            this.log("Success");
        } else {
            String message;
            if (this.errorProperty != null) {
                this.getProject().setProperty(this.errorProperty, "true");
            }
            if ((rc & 4) != 0) {
                message = "At least one error occurred!";
                if (this.failIfBugFound) {
                    throw new BuildException(message);
                }
                this.log(message, 0);
            }
            if ((rc & 1) != 0) {
                message = "At least one unexpected bug is reported!";
                if (this.failIfBugFound) {
                    throw new BuildException(message);
                }
                this.log(message, 0);
            }
        }
    }
}

