/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnull;
import mockit.asm.ArrayType;
import mockit.asm.JavaType;
import mockit.asm.PrimitiveType;
import mockit.internal.util.ClassLoad;

public final class TypeDescriptor {
    private static final Class<?>[] NO_PARAMETERS = new Class[0];

    private TypeDescriptor() {
    }

    @Nonnull
    public static Class<?>[] getParameterTypes(@Nonnull String methodDesc) {
        JavaType[] paramTypes = JavaType.getArgumentTypes(methodDesc);
        if (paramTypes.length == 0) {
            return NO_PARAMETERS;
        }
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramClasses[i] = TypeDescriptor.getClassForType(paramTypes[i]);
        }
        return paramClasses;
    }

    @Nonnull
    public static Class<?> getReturnType(@Nonnull String methodSignature) {
        String methodDesc = TypeDescriptor.methodDescriptionWithoutTypeArguments(methodSignature);
        JavaType returnType = JavaType.getReturnType(methodDesc);
        return TypeDescriptor.getClassForType(returnType);
    }

    @Nonnull
    private static String methodDescriptionWithoutTypeArguments(@Nonnull String methodSignature) {
        int p;
        while ((p = methodSignature.indexOf(60)) >= 0) {
            String firstPart = methodSignature.substring(0, p);
            int q = methodSignature.indexOf(62, p) + 1;
            if (methodSignature.charAt(q) == '.') {
                methodSignature = firstPart + '$' + methodSignature.substring(q + 1);
                continue;
            }
            methodSignature = firstPart + methodSignature.substring(q);
        }
        return methodSignature;
    }

    @Nonnull
    public static Class<?> getClassForType(@Nonnull JavaType type) {
        if (type instanceof PrimitiveType) {
            return ((PrimitiveType)type).getType();
        }
        String className = type instanceof ArrayType ? type.getDescriptor().replace('/', '.') : type.getClassName();
        return ClassLoad.loadClass(className);
    }
}

