/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import javax.annotation.Nonnull;
import mockit.asm.JavaType;
import mockit.asm.MethodVisitor;
import mockit.asm.PrimitiveType;
import mockit.asm.ReferenceType;

public final class TypeConversion {
    private TypeConversion() {
    }

    public static void generateCastToObject(@Nonnull MethodVisitor mv, @Nonnull JavaType type) {
        if (type instanceof PrimitiveType) {
            String wrapperTypeDesc = ((PrimitiveType)type).getWrapperTypeDesc();
            String desc = '(' + type.getDescriptor() + ")L" + wrapperTypeDesc + ';';
            mv.visitMethodInsn(184, wrapperTypeDesc, "valueOf", desc, false);
        }
    }

    public static void generateCastFromObject(@Nonnull MethodVisitor mv, @Nonnull JavaType toType) {
        if (toType instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)toType;
            if (primitiveType.getType() == Void.TYPE) {
                mv.visitInsn(87);
            } else {
                TypeConversion.generateTypeCheck(mv, primitiveType);
                TypeConversion.generateUnboxing(mv, primitiveType);
            }
        } else {
            TypeConversion.generateTypeCheck(mv, toType);
        }
    }

    private static void generateTypeCheck(@Nonnull MethodVisitor mv, @Nonnull JavaType toType) {
        String typeDesc = toType instanceof ReferenceType ? ((ReferenceType)toType).getInternalName() : ((PrimitiveType)toType).getWrapperTypeDesc();
        mv.visitTypeInsn(192, typeDesc);
    }

    private static void generateUnboxing(@Nonnull MethodVisitor mv, @Nonnull PrimitiveType primitiveType) {
        String owner = primitiveType.getWrapperTypeDesc();
        String methodName = primitiveType.getClassName() + "Value";
        String methodDesc = "()" + primitiveType.getTypeCode();
        mv.visitMethodInsn(182, owner, methodName, methodDesc, false);
    }

    public static void generateCastOrUnboxing(@Nonnull MethodVisitor mv, @Nonnull JavaType parameterType, int opcode) {
        if (opcode == 58) {
            TypeConversion.generateTypeCheck(mv, parameterType);
            return;
        }
        String typeDesc = ((ReferenceType)parameterType).getInternalName();
        mv.visitTypeInsn(192, typeDesc);
        PrimitiveType primitiveType = PrimitiveType.getCorrespondingPrimitiveTypeIfWrapperType(typeDesc);
        assert (primitiveType != null);
        TypeConversion.generateUnboxing(mv, primitiveType);
    }

    public static boolean isPrimitiveWrapper(@Nonnull String typeDesc) {
        return PrimitiveType.getCorrespondingPrimitiveTypeIfWrapperType(typeDesc) != null;
    }

    public static boolean isBoxing(@Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        return desc.charAt(2) == ')' && "valueOf".equals(name) && TypeConversion.isPrimitiveWrapper(owner);
    }

    public static boolean isUnboxing(int opcode, @Nonnull String owner, @Nonnull String desc) {
        return opcode == 182 && desc.charAt(1) == ')' && TypeConversion.isPrimitiveWrapper(owner);
    }
}

