/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import mockit.MockUp;
import mockit.coverage.CodeCoverage;
import mockit.integration.junit4.internal.FakeFrameworkMethod;
import mockit.integration.junit4.internal.RunNotifierDecorator;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.StackTrace;
import mockit.internal.util.Utilities;

final class JMockitInitialization {
    private JMockitInitialization() {
    }

    static void initialize(@Nonnull Instrumentation inst) {
        JMockitInitialization.preventEventualClassLoadingConflicts();
        JMockitInitialization.applyInternalStartupFakesAsNeeded();
        if (CodeCoverage.active()) {
            inst.addTransformer(new CodeCoverage());
        }
        JMockitInitialization.applyUserSpecifiedStartupFakesIfAny();
    }

    private static void preventEventualClassLoadingConflicts() {
        TimeZone.getDefault();
        Locale.getDefault();
        Currency.getInstance(Locale.CANADA);
        DefaultValues.computeForReturnType("()J");
        Utilities.calledFromSpecialThread();
    }

    private static void applyInternalStartupFakesAsNeeded() {
        if (FakeFrameworkMethod.hasDependenciesInClasspath()) {
            new RunNotifierDecorator();
            new FakeFrameworkMethod();
        }
    }

    private static void applyUserSpecifiedStartupFakesIfAny() {
        Collection<String> fakeClasses = JMockitInitialization.getFakeClasses();
        for (String fakeClassName : fakeClasses) {
            JMockitInitialization.applyStartupFake(fakeClassName);
        }
    }

    @Nonnull
    private static Collection<String> getFakeClasses() {
        String commaOrSpaceSeparatedValues = System.getProperty("fakes");
        if (commaOrSpaceSeparatedValues == null) {
            return Collections.emptyList();
        }
        String[] fakeClassNames = commaOrSpaceSeparatedValues.split("\\s*,\\s*|\\s+");
        HashSet<String> uniqueClassNames = new HashSet<String>(Arrays.asList(fakeClassNames));
        uniqueClassNames.remove("");
        return uniqueClassNames;
    }

    private static void applyStartupFake(@Nonnull String fakeClassName) {
        String argument = null;
        int p = fakeClassName.indexOf(61);
        if (p > 0) {
            argument = fakeClassName.substring(p + 1);
            fakeClassName = fakeClassName.substring(0, p);
        }
        try {
            Class fakeClass = ClassLoad.loadClassAtStartup(fakeClassName);
            if (MockUp.class.isAssignableFrom(fakeClass)) {
                if (argument == null) {
                    ConstructorReflection.newInstanceUsingDefaultConstructor(fakeClass);
                } else {
                    ConstructorReflection.newInstance(fakeClass, argument);
                }
            }
        }
        catch (UnsupportedOperationException fakeClass) {
        }
        catch (Throwable unexpectedFailure) {
            StackTrace.filterStackTrace(unexpectedFailure);
            unexpectedFailure.printStackTrace();
        }
    }
}

