/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.Utilities;
import sun.tools.attach.AixVirtualMachine;
import sun.tools.attach.BsdVirtualMachine;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

public final class AgentLoader {
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        @Nullable
        public String name() {
            return null;
        }

        @Override
        @Nullable
        public String type() {
            return null;
        }

        @Override
        @Nullable
        public VirtualMachine attachVirtualMachine(String id) {
            return null;
        }

        @Override
        @Nullable
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };
    @Nonnull
    private final String jarFilePath;
    @Nullable
    private String pidForTargetVM;

    AgentLoader() {
        if (Utilities.JAVA_VERSION < 1.7f) {
            throw new IllegalStateException("JMockit requires a Java 7+ VM");
        }
        String currentPath = "";
        try {
            currentPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (currentPath.endsWith(".jar")) {
            currentPath = new File(currentPath).getAbsolutePath();
        } else {
            int p = currentPath.lastIndexOf("/main/target/classes");
            currentPath = currentPath.substring(0, p);
            currentPath = new File(currentPath, "agent.jar").getPath();
        }
        this.jarFilePath = currentPath;
    }

    public AgentLoader(@Nonnull String pid) {
        this();
        this.pidForTargetVM = pid;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadAgent(@Nullable String options) {
        VirtualMachine vm;
        if (AttachProvider.providers().isEmpty()) {
            if (!Utilities.HOTSPOT_VM) {
                String helpMessage = this.getHelpMessageForNonHotSpotVM();
                throw new IllegalStateException(helpMessage);
            }
            vm = this.getVirtualMachineImplementationFromEmbeddedOnes();
        } else {
            vm = this.attachToRunningVM();
        }
        this.loadAgentAndDetachFromRunningVM(vm, options);
    }

    @Nonnull
    private VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes() {
        Class<? extends VirtualMachine> vmClass = AgentLoader.findVirtualMachineClassAccordingToOS();
        String pid = this.getProcessIdForTargetVM();
        try {
            Class[] parameterTypes = new Class[]{AttachProvider.class, String.class};
            Constructor<? extends VirtualMachine> vmConstructor = vmClass.getConstructor(parameterTypes);
            VirtualMachine newVM = vmConstructor.newInstance(ATTACH_PROVIDER, pid);
            return newVM;
        }
        catch (IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native library for Attach API not available in this JRE", e);
        }
    }

    @Nonnull
    private static Class<? extends VirtualMachine> findVirtualMachineClassAccordingToOS() {
        if (File.separatorChar == '\\') {
            return WindowsVirtualMachine.class;
        }
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
            return LinuxVirtualMachine.class;
        }
        if (osName.contains("FreeBSD") || osName.startsWith("Mac OS X")) {
            return BsdVirtualMachine.class;
        }
        if (osName.startsWith("Solaris") || osName.contains("SunOS")) {
            return SolarisVirtualMachine.class;
        }
        if (osName.contains("AIX")) {
            return AixVirtualMachine.class;
        }
        throw new IllegalStateException("Cannot use Attach API on unknown OS: " + osName);
    }

    @Nonnull
    private String getProcessIdForTargetVM() {
        if (this.pidForTargetVM != null) {
            return this.pidForTargetVM;
        }
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    @Nonnull
    private String getHelpMessageForNonHotSpotVM() {
        String vmName = System.getProperty("java.vm.name");
        String helpMessage = "To run on " + vmName;
        if (vmName.contains("J9")) {
            helpMessage = helpMessage + ", add <IBM SDK>/lib/tools.jar to the runtime classpath (before jmockit), or";
        }
        return helpMessage + " use -javaagent:" + this.jarFilePath;
    }

    @Nonnull
    private VirtualMachine attachToRunningVM() {
        String pid = this.getProcessIdForTargetVM();
        try {
            return VirtualMachine.attach(pid);
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            if (e.getMessage().contains("current VM")) {
                throw new IllegalStateException("Running on JDK 9 requires -javaagent:<proper path>/jmockit-1.n.jar or -Djdk.attach.allowAttachSelf");
            }
            throw new RuntimeException(e);
        }
    }

    private void loadAgentAndDetachFromRunningVM(@Nonnull VirtualMachine vm, @Nullable String options) {
        try {
            vm.loadAgent(this.jarFilePath, options);
            vm.detach();
        }
        catch (AgentInitializationException | AgentLoadException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

