/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.constructor;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.JavaType;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.constructor.ConstructorParameter;
import mockit.internal.injection.full.FullInjection;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.state.ParameterNames;
import mockit.internal.state.TestRun;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.Utilities;

public final class ConstructorInjection
extends Injector {
    @Nonnull
    private final Constructor<?> constructor;

    public ConstructorInjection(@Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Constructor<?> constructor) {
        super(injectionState, fullInjection);
        this.constructor = constructor;
    }

    @Nonnull
    public Object instantiate(@Nonnull List<InjectionProvider> parameterProviders, @Nonnull TestedClass testedClass) {
        Type[] parameterTypes = this.constructor.getGenericParameterTypes();
        int n = parameterTypes.length;
        List<InjectionProvider> consumedInjectables = n == 0 ? null : this.injectionState.saveConsumedInjectionProviders();
        Object[] arguments = n == 0 ? Utilities.NO_ARGS : new Object[n];
        boolean varArgs = this.constructor.isVarArgs();
        if (varArgs) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            InjectionProvider parameterProvider = parameterProviders.get(i);
            Object value = parameterProvider instanceof ConstructorParameter ? this.createOrReuseArgumentValue((ConstructorParameter)parameterProvider) : this.getArgumentValueToInject(parameterProvider, i);
            if (value == null) continue;
            Type parameterType = parameterTypes[i];
            arguments[i] = InjectionPoint.wrapInProviderIfNeeded(parameterType, value);
        }
        if (varArgs) {
            Type parameterType = parameterTypes[n];
            arguments[n] = this.obtainInjectedVarargsArray(parameterType, testedClass);
        }
        if (consumedInjectables != null) {
            this.injectionState.restoreConsumedInjectionProviders(consumedInjectables);
        }
        return this.invokeConstructor(arguments);
    }

    @Nonnull
    private Object createOrReuseArgumentValue(@Nonnull ConstructorParameter constructorParameter) {
        Object value = constructorParameter.getValue(null);
        if (value != null) {
            return value;
        }
        Type parameterType = constructorParameter.getDeclaredType();
        this.injectionState.setTypeOfInjectionPoint(parameterType);
        String qualifiedName = InjectionPoint.getQualifiedName(constructorParameter.getAnnotations());
        Class<?> parameterClass = constructorParameter.getClassOfDeclaredType();
        TestedClass nextTestedClass = new TestedClass(parameterType, parameterClass);
        assert (this.fullInjection != null);
        value = this.fullInjection.createOrReuseInstance(nextTestedClass, this, constructorParameter, qualifiedName);
        if (value == null) {
            String parameterName = constructorParameter.getName();
            String message = "Missing @Tested or @Injectable" + this.missingValueDescription(parameterName) + "\r\n  when initializing " + this.fullInjection;
            throw new IllegalStateException(message);
        }
        return value;
    }

    @Nullable
    private Object getArgumentValueToInject(@Nonnull InjectionProvider injectable, int parameterIndex) {
        Object argument = this.injectionState.getValueToInject(injectable);
        if (argument == null) {
            String constructorDesc;
            String classDesc = this.getClassDesc();
            String parameterName = ParameterNames.getName(classDesc, constructorDesc = this.getConstructorDesc(), parameterIndex);
            if (parameterName == null) {
                parameterName = injectable.getName();
            }
            throw new IllegalArgumentException("No injectable value available" + this.missingValueDescription(parameterName));
        }
        return argument == InjectionProvider.NULL ? null : argument;
    }

    @Nonnull
    private String getClassDesc() {
        return JavaType.getInternalName(this.constructor.getDeclaringClass());
    }

    @Nonnull
    private String getConstructorDesc() {
        return "<init>" + JavaType.getConstructorDescriptor(this.constructor);
    }

    @Nonnull
    private Object obtainInjectedVarargsArray(@Nonnull Type parameterType, @Nonnull TestedClass testedClass) {
        MockedType injectable;
        Type varargsElementType = InjectionPoint.getTypeOfInjectionPointFromVarargsParameter(parameterType);
        this.injectionState.setTypeOfInjectionPoint(varargsElementType);
        ArrayList<Object> varargValues = new ArrayList<Object>();
        while ((injectable = this.injectionState.findNextInjectableForInjectionPoint(testedClass)) != null) {
            Object value = this.injectionState.getValueToInject(injectable);
            if (value == null) continue;
            value = InjectionPoint.wrapInProviderIfNeeded(varargsElementType, value);
            varargValues.add(value);
        }
        Object varargArray = ConstructorInjection.newArrayFromList(varargsElementType, varargValues);
        return varargArray;
    }

    @Nonnull
    private static Object newArrayFromList(@Nonnull Type elementType, @Nonnull List<Object> values) {
        Class<?> componentType = Utilities.getClassType(elementType);
        int elementCount = values.size();
        Object array = Array.newInstance(componentType, elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    @Nonnull
    private String missingValueDescription(@Nonnull String name) {
        String classDesc = this.getClassDesc();
        String constructorDesc = this.getConstructorDesc();
        String constructorDescription = new MethodFormatter(classDesc, constructorDesc).toString();
        int p = constructorDescription.indexOf(35);
        String friendlyConstructorDesc = constructorDescription.substring(p + 1).replace("java.lang.", "");
        return " for parameter \"" + name + "\" in constructor " + friendlyConstructorDesc;
    }

    @Nonnull
    private Object invokeConstructor(@Nonnull Object[] arguments) {
        TestRun.exitNoMockingZone();
        try {
            Object obj = ConstructorReflection.invoke(this.constructor, arguments);
            return obj;
        }
        finally {
            TestRun.enterNoMockingZone();
        }
    }
}

