/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ClassVisitor;
import mockit.internal.classGeneration.ImplementationClass;
import mockit.internal.expectations.mocking.SubclassGenerationModifier;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.constructor.ConstructorInjection;
import mockit.internal.injection.constructor.ConstructorSearch;
import mockit.internal.injection.full.FullInjection;
import mockit.internal.state.TestRun;

public final class TestedObjectCreation {
    @Nonnull
    private final InjectionState injectionState;
    @Nullable
    private final FullInjection fullInjection;
    @Nonnull
    final TestedClass testedClass;

    TestedObjectCreation(@Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Type declaredType, @Nonnull Class<?> declaredClass) {
        this.injectionState = injectionState;
        this.fullInjection = fullInjection;
        Class<?> actualTestedClass = Modifier.isAbstract(declaredClass.getModifiers()) ? TestedObjectCreation.generateSubclass(declaredType, declaredClass) : declaredClass;
        this.testedClass = new TestedClass(declaredType, actualTestedClass);
    }

    @Nonnull
    private static Class<?> generateSubclass(final @Nonnull Type testedType, final @Nonnull Class<?> abstractClass) {
        Class generatedSubclass = new ImplementationClass<Object>(abstractClass){

            @Override
            @Nonnull
            protected ClassVisitor createMethodBodyGenerator(@Nonnull byte[] classfile) {
                return new SubclassGenerationModifier(abstractClass, testedType, classfile, this.generatedClassName, true);
            }
        }.generateClass();
        TestRun.mockFixture().registerMockedClass(generatedSubclass);
        return generatedSubclass;
    }

    public TestedObjectCreation(@Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Class<?> implementationClass) {
        this.injectionState = injectionState;
        this.fullInjection = fullInjection;
        this.testedClass = new TestedClass(implementationClass, implementationClass);
    }

    @Nonnull
    public Object create() {
        ConstructorSearch constructorSearch = new ConstructorSearch(this.injectionState, this.testedClass, this.fullInjection != null);
        Constructor<?> constructor = constructorSearch.findConstructorToUse();
        if (constructor == null) {
            String description = constructorSearch.getDescription();
            throw new IllegalArgumentException("No constructor in tested class that can be satisfied by available tested/injectable values" + description);
        }
        ConstructorInjection constructorInjection = new ConstructorInjection(this.injectionState, this.fullInjection, constructor);
        return constructorInjection.instantiate(constructorSearch.parameterProviders, this.testedClass);
    }
}

