/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletConfig;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class LifecycleMethods {
    @Nonnull
    private final List<Class<?>> classesSearched = new ArrayList();
    @Nonnull
    private final Map<Class<?>, Method> initializationMethods = new IdentityHashMap();
    @Nonnull
    private final Map<Class<?>, Method> terminationMethods = new IdentityHashMap();
    @Nonnull
    private final Map<Class<?>, Object> objectsWithTerminationMethodsToExecute = new IdentityHashMap();
    @Nullable
    Object servletConfig;

    LifecycleMethods() {
    }

    public void findLifecycleMethods(@Nonnull Class<?> testedClass) {
        if (testedClass.isInterface() || this.classesSearched.contains(testedClass)) {
            return;
        }
        boolean isServlet = InjectionPoint.isServlet(testedClass);
        Class<?> classWithLifecycleMethods = testedClass;
        do {
            this.findLifecycleMethodsInSingleClass(isServlet, classWithLifecycleMethods);
        } while ((classWithLifecycleMethods = classWithLifecycleMethods.getSuperclass()) != Object.class);
        this.classesSearched.add(testedClass);
    }

    private void findLifecycleMethodsInSingleClass(boolean isServlet, @Nonnull Class<?> classWithLifecycleMethods) {
        Method initializationMethod = null;
        Method terminationMethod = null;
        int methodsFoundInSameClass = 0;
        for (Method method : classWithLifecycleMethods.getDeclaredMethods()) {
            if (method.isSynthetic()) continue;
            if (initializationMethod == null && LifecycleMethods.isInitializationMethod(method, isServlet)) {
                this.initializationMethods.put(classWithLifecycleMethods, method);
                initializationMethod = method;
                ++methodsFoundInSameClass;
            } else if (terminationMethod == null && LifecycleMethods.isTerminationMethod(method, isServlet)) {
                this.terminationMethods.put(classWithLifecycleMethods, method);
                terminationMethod = method;
                ++methodsFoundInSameClass;
            }
            if (methodsFoundInSameClass == 2) break;
        }
    }

    private static boolean isInitializationMethod(@Nonnull Method method, boolean isServlet) {
        if (LifecycleMethods.hasLifecycleAnnotation(method, true)) {
            return true;
        }
        if (isServlet && "init".equals(method.getName())) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length == 1 && parameterTypes[0] == ServletConfig.class;
        }
        return false;
    }

    private static boolean hasLifecycleAnnotation(@Nonnull Method method, boolean postConstruct) {
        try {
            Class lifecycleAnnotation;
            Class clazz = lifecycleAnnotation = postConstruct ? PostConstruct.class : PreDestroy.class;
            if (method.isAnnotationPresent(lifecycleAnnotation)) {
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    private static boolean isTerminationMethod(@Nonnull Method method, boolean isServlet) {
        return LifecycleMethods.hasLifecycleAnnotation(method, false) || isServlet && "destroy".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    public void executeInitializationMethodsIfAny(@Nonnull Class<?> testedClass, @Nonnull Object testedObject) {
        Method preDestroyMethod;
        Method postConstructMethod;
        Class<?> superclass = testedClass.getSuperclass();
        if (superclass != Object.class) {
            this.executeInitializationMethodsIfAny(superclass, testedObject);
        }
        if ((postConstructMethod = this.initializationMethods.get(testedClass)) != null) {
            this.executeInitializationMethod(testedObject, postConstructMethod);
        }
        if ((preDestroyMethod = this.terminationMethods.get(testedClass)) != null) {
            this.objectsWithTerminationMethodsToExecute.put(testedClass, testedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInitializationMethod(@Nonnull Object testedObject, @Nonnull Method initializationMethod) {
        Object[] args = Utilities.NO_ARGS;
        if ("init".equals(initializationMethod.getName()) && initializationMethod.getParameterTypes().length == 1) {
            args = new Object[]{this.servletConfig};
        }
        TestRun.exitNoMockingZone();
        try {
            MethodReflection.invoke(testedObject, initializationMethod, args);
        }
        finally {
            TestRun.enterNoMockingZone();
        }
    }

    void executeTerminationMethodsIfAny() {
        try {
            for (Map.Entry<Class<?>, Object> testedClassAndObject : this.objectsWithTerminationMethodsToExecute.entrySet()) {
                this.executeTerminationMethod(testedClassAndObject.getKey(), testedClassAndObject.getValue());
            }
        }
        finally {
            this.objectsWithTerminationMethodsToExecute.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTerminationMethod(@Nonnull Class<?> testedClass, @Nonnull Object testedObject) {
        Method terminationMethod = this.terminationMethods.get(testedClass);
        TestRun.exitNoMockingZone();
        try {
            MethodReflection.invoke(testedObject, terminationMethod, new Object[0]);
        }
        catch (AssertionError | RuntimeException object) {
        }
        finally {
            TestRun.enterNoMockingZone();
        }
    }
}

