/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.servlet.ServletConfig;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InterfaceResolution;
import mockit.internal.injection.LifecycleMethods;
import mockit.internal.injection.MultiValuedProvider;
import mockit.internal.injection.TestedClass;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class InjectionState {
    @Nonnull
    private static final Map<InjectionPoint, Object> globalDependencies = new ConcurrentHashMap<InjectionPoint, Object>(2);
    @Nonnull
    private final Map<InjectionPoint, Object> testedObjects = new LinkedHashMap<InjectionPoint, Object>();
    @Nonnull
    private final Map<InjectionPoint, Object> instantiatedDependencies = new LinkedHashMap<InjectionPoint, Object>();
    @Nonnull
    private List<MockedType> injectables = Collections.emptyList();
    @Nonnull
    private List<InjectionProvider> consumedInjectionProviders = new ArrayList<InjectionProvider>();
    @Nonnull
    public final LifecycleMethods lifecycleMethods = new LifecycleMethods();
    @Nonnull
    final InterfaceResolution interfaceResolution = new InterfaceResolution();
    @Nullable
    private BeanExporter beanExporter;
    private Object currentTestClassInstance;
    private Type typeOfInjectionPoint;

    InjectionState() {
    }

    boolean setInjectables(@Nonnull List<MockedType> injectables) {
        if (injectables.isEmpty()) {
            this.injectables = Collections.emptyList();
            return false;
        }
        this.injectables = new ArrayList<MockedType>(injectables);
        return true;
    }

    void buildListOfInjectableFields(@Nonnull Object testClassInstance, @Nonnull List<MockedType> injectables) {
        this.currentTestClassInstance = testClassInstance;
        this.setInjectables(injectables);
        this.getServletConfigForInitMethodsIfAny(testClassInstance);
    }

    void buildListsOfInjectables(@Nonnull Object testClassInstance, @Nonnull List<MockedType> injectables) {
        this.currentTestClassInstance = testClassInstance;
        this.setInjectables(injectables);
        ParameterTypeRedefinitions paramTypeRedefs = TestRun.getExecutingTest().getParameterRedefinitions();
        if (paramTypeRedefs != null) {
            this.addInjectables(paramTypeRedefs);
        }
        this.getServletConfigForInitMethodsIfAny(testClassInstance);
    }

    private void addInjectables(@Nonnull ParameterTypeRedefinitions paramTypeRedefs) {
        List<MockedType> injectableParameters = paramTypeRedefs.getInjectableParameters();
        if (!injectableParameters.isEmpty()) {
            if (this.injectables.isEmpty()) {
                this.injectables = new ArrayList<MockedType>(injectableParameters);
            } else {
                this.injectables.addAll(injectableParameters);
            }
        }
    }

    private void getServletConfigForInitMethodsIfAny(@Nonnull Object testClassInstance) {
        if (InjectionPoint.SERVLET_CLASS != null) {
            for (InjectionProvider injectionProvider : this.injectables) {
                if (injectionProvider.getDeclaredType() != ServletConfig.class) continue;
                this.lifecycleMethods.servletConfig = injectionProvider.getValue(testClassInstance);
                break;
            }
        }
    }

    void buildListsOfInjectables(@Nonnull Object testClassInstance, @Nonnull ParameterTypeRedefinitions paramTypeRedefs) {
        this.currentTestClassInstance = testClassInstance;
        this.addInjectables(paramTypeRedefs);
        this.getServletConfigForInitMethodsIfAny(testClassInstance);
    }

    Object getCurrentTestClassInstance() {
        return this.currentTestClassInstance;
    }

    public void setTypeOfInjectionPoint(@Nonnull Type typeOfInjectionPoint) {
        this.typeOfInjectionPoint = typeOfInjectionPoint;
    }

    public boolean isAssignableToInjectionPoint(@Nonnull Type injectableType, @Nonnull TestedClass testedClass) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (testedClass.reflection.areMatchingTypes(this.typeOfInjectionPoint, injectableType)) {
            return true;
        }
        if (this.typeOfInjectionPoint instanceof ParameterizedType && (Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)this.typeOfInjectionPoint).getRawType()) || InjectionPoint.INJECT_CLASS != null && Provider.class.isAssignableFrom(classOfInjectionPoint))) {
            Type providedType = parameterizedType.getActualTypeArguments()[0];
            if (providedType.equals(injectableType)) {
                return true;
            }
            Class<?> injectableClass = Utilities.getClassType(injectableType);
            Class<?> providedClass = Utilities.getClassType(providedType);
            return providedClass.isAssignableFrom(injectableClass);
        }
        return false;
    }

    @Nullable
    public MockedType findNextInjectableForInjectionPoint(@Nonnull TestedClass testedClass) {
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass) || this.consumedInjectionProviders.contains(injectable)) continue;
            return injectable;
        }
        return null;
    }

    private boolean hasTypeAssignableToInjectionPoint(@Nonnull InjectionProvider injectable, @Nonnull TestedClass testedClass) {
        Type declaredType = injectable.getDeclaredType();
        return this.isAssignableToInjectionPoint(declaredType, testedClass);
    }

    @Nonnull
    List<MockedType> findInjectablesByType(@Nonnull TestedClass testedClass) {
        ArrayList<MockedType> found = new ArrayList<MockedType>();
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass) || this.consumedInjectionProviders.contains(injectable)) continue;
            found.add(injectable);
        }
        return found;
    }

    @Nullable
    public InjectionProvider getProviderByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint, @Nonnull TestedClass testedClass) {
        Type elementTypeOfIterable = InjectionState.getElementTypeIfIterable(this.typeOfInjectionPoint);
        if (elementTypeOfIterable != null) {
            return this.findInjectablesByTypeOnly(elementTypeOfIterable, testedClass);
        }
        return this.findInjectableByTypeAndOptionallyName(nameOfInjectionPoint, testedClass);
    }

    @Nullable
    private static Type getElementTypeIfIterable(@Nonnull Type injectableType) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (injectableType instanceof ParameterizedType && Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)injectableType).getRawType())) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    @Nullable
    private InjectionProvider findInjectablesByTypeOnly(@Nonnull Type elementType, @Nonnull TestedClass testedClass) {
        GenericTypeReflection typeReflection = testedClass.reflection;
        MultiValuedProvider found = null;
        for (MockedType injectable : this.injectables) {
            Type injectableType = injectable.getDeclaredType();
            Type elementTypeOfIterable = InjectionState.getElementTypeIfIterable(injectableType);
            if (elementTypeOfIterable != null && typeReflection.areMatchingTypes(elementType, elementTypeOfIterable)) {
                return injectable;
            }
            if (!this.isAssignableToInjectionPoint(injectableType, testedClass)) continue;
            if (found == null) {
                found = new MultiValuedProvider(elementType);
            }
            found.addInjectable(injectable);
        }
        return found;
    }

    @Nullable
    private InjectionProvider findInjectableByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint, @Nonnull TestedClass testedClass) {
        MockedType foundInjectable = null;
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass)) continue;
            if (nameOfInjectionPoint.equals(injectable.getName())) {
                return injectable;
            }
            if (foundInjectable != null) continue;
            foundInjectable = injectable;
        }
        return foundInjectable;
    }

    @Nullable
    public MockedType findInjectableByTypeAndName(@Nonnull String nameOfInjectionPoint, @Nonnull TestedClass testedClass) {
        for (MockedType injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass) || !nameOfInjectionPoint.equals(injectable.getName())) continue;
            return injectable;
        }
        return null;
    }

    @Nullable
    public Object getValueToInject(@Nonnull InjectionProvider injectionProvider) {
        if (this.consumedInjectionProviders.contains(injectionProvider)) {
            return null;
        }
        Object value = injectionProvider.getValue(this.currentTestClassInstance);
        if (value != null) {
            this.consumedInjectionProviders.add(injectionProvider);
        }
        return value;
    }

    void resetConsumedInjectionProviders() {
        this.consumedInjectionProviders.clear();
    }

    @Nonnull
    public List<InjectionProvider> saveConsumedInjectionProviders() {
        List<InjectionProvider> previouslyConsumed = this.consumedInjectionProviders;
        this.consumedInjectionProviders = new ArrayList<InjectionProvider>();
        return previouslyConsumed;
    }

    public void restoreConsumedInjectionProviders(@Nonnull List<InjectionProvider> previouslyConsumed) {
        this.consumedInjectionProviders = previouslyConsumed;
    }

    void saveTestedObject(@Nonnull InjectionPoint key, @Nonnull Object testedObject) {
        this.testedObjects.put(key, testedObject);
    }

    @Nullable
    Object getTestedInstance(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        Object testedInstance;
        Object object = testedInstance = this.instantiatedDependencies.isEmpty() ? null : this.findPreviouslyInstantiatedDependency(testedType, nameOfInjectionPoint);
        if (testedInstance == null) {
            testedInstance = this.testedObjects.isEmpty() ? null : this.getValueFromExistingTestedObject(testedType, nameOfInjectionPoint);
        }
        return testedInstance;
    }

    @Nullable
    private Object findPreviouslyInstantiatedDependency(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        InjectionPoint injectionPoint = new InjectionPoint(testedType, nameOfInjectionPoint);
        Object dependency = this.instantiatedDependencies.get(injectionPoint);
        if (dependency == null && (dependency = this.instantiatedDependencies.get(injectionPoint = new InjectionPoint(testedType))) == null) {
            dependency = InjectionState.findMatchingObject(this.instantiatedDependencies, null, injectionPoint);
        }
        return dependency;
    }

    @Nullable
    private Object getValueFromExistingTestedObject(@Nonnull Type testedType, @Nonnull String nameOfInjectionPoint) {
        InjectionPoint injectionPoint = new InjectionPoint(testedType, nameOfInjectionPoint);
        for (Object testedObject : this.testedObjects.values()) {
            Object fieldValue = InjectionState.getValueFromFieldOfEquivalentTypeAndName(injectionPoint, testedObject);
            if (fieldValue == null) continue;
            return fieldValue;
        }
        return null;
    }

    @Nullable
    private static Object getValueFromFieldOfEquivalentTypeAndName(@Nonnull InjectionPoint injectionPoint, @Nonnull Object testedObject) {
        for (Field internalField : testedObject.getClass().getDeclaredFields()) {
            String qualifiedName;
            boolean qualified;
            String fieldName;
            Type fieldType = internalField.getGenericType();
            InjectionPoint internalInjectionPoint = new InjectionPoint(fieldType, fieldName = (qualified = (qualifiedName = InjectionPoint.getQualifiedName(internalField.getDeclaredAnnotations())) != null) ? qualifiedName : internalField.getName(), qualified);
            if (!internalInjectionPoint.equals(injectionPoint)) continue;
            Object fieldValue = FieldReflection.getFieldValue(internalField, testedObject);
            return fieldValue;
        }
        return null;
    }

    @Nullable
    public static <D> D getGlobalDependency(@Nonnull InjectionPoint key) {
        return (D)globalDependencies.get(key);
    }

    @Nullable
    public Object getTestedValue(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        Object testedValue = this.testedObjects.get(injectionPoint);
        if (testedValue == null) {
            testedValue = InjectionState.findMatchingObject(this.testedObjects, testedClass, injectionPoint);
        }
        return testedValue;
    }

    @Nullable
    public Object getInstantiatedDependency(@Nullable TestedClass testedClass, @Nonnull InjectionPoint dependencyKey) {
        Object dependency = this.testedObjects.get(dependencyKey);
        if (dependency == null && (dependency = InjectionState.findMatchingObject(this.testedObjects, testedClass, dependencyKey)) == null && (dependency = this.instantiatedDependencies.get(dependencyKey)) == null && (dependency = InjectionState.findMatchingObject(this.instantiatedDependencies, testedClass, dependencyKey)) == null) {
            dependency = InjectionState.findMatchingObject(globalDependencies, testedClass, dependencyKey);
        }
        return dependency;
    }

    @Nullable
    private static Object findMatchingObject(@Nonnull Map<InjectionPoint, Object> availableObjects, @Nullable TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        if (availableObjects.isEmpty()) {
            return null;
        }
        GenericTypeReflection reflection = testedClass == null ? null : testedClass.reflection;
        Type dependencyType = injectionPoint.type;
        Object found = null;
        for (Map.Entry<InjectionPoint, Object> injectionPointAndObject : availableObjects.entrySet()) {
            InjectionPoint dependencyIP = injectionPointAndObject.getKey();
            Object dependencyObject = injectionPointAndObject.getValue();
            if (injectionPoint.equals(dependencyIP)) {
                return dependencyObject;
            }
            if (reflection != null) {
                if (!reflection.areMatchingTypes(dependencyType, dependencyIP.type)) continue;
                found = dependencyObject;
            }
            if (!injectionPoint.hasSameName(dependencyIP)) continue;
            return dependencyObject;
        }
        return injectionPoint.qualified ? null : found;
    }

    public void saveInstantiatedDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        this.instantiatedDependencies.put(dependencyKey, dependency);
    }

    public static void saveGlobalDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        globalDependencies.put(dependencyKey, dependency);
    }

    void clearTestedObjectsAndInstantiatedDependencies() {
        this.testedObjects.clear();
        this.instantiatedDependencies.clear();
    }

    @Nonnull
    BeanExporter getBeanExporter() {
        if (this.beanExporter == null) {
            this.beanExporter = new BeanExporter(this);
        }
        return this.beanExporter;
    }

    @Nullable
    public Class<?> resolveInterface(@Nonnull Class<?> anInterface) {
        return this.interfaceResolution.resolveInterface(anInterface, this.currentTestClassInstance);
    }
}

