/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.field.FieldInjection;
import mockit.internal.injection.full.FullInjection;

public final class BeanExporter {
    @Nonnull
    private final InjectionState injectionState;

    BeanExporter(@Nonnull InjectionState injectionState) {
        this.injectionState = injectionState;
    }

    @Nullable
    public Object getBean(@Nonnull String name) {
        InjectionPoint injectionPoint = new InjectionPoint((Type)((Object)Object.class), name, true);
        Object bean = this.injectionState.getInstantiatedDependency(null, injectionPoint);
        return bean;
    }

    @Nullable
    public <T> T getBean(@Nonnull Class<T> beanType) {
        TestedClass testedClass = new TestedClass(beanType, beanType);
        String beanName = BeanExporter.getBeanNameFromType(beanType);
        FullInjection injection = new FullInjection(this.injectionState, beanType, beanName);
        FieldInjection injector = new FieldInjection(this.injectionState, injection);
        Object bean = injection.createOrReuseInstance(testedClass, injector, null, beanName);
        return (T)bean;
    }

    @Nonnull
    private static String getBeanNameFromType(@Nonnull Class<?> beanType) {
        String name = beanType.getSimpleName();
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

