/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Modifier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.asm.ClassReader;
import mockit.asm.JavaType;
import mockit.asm.Label;
import mockit.asm.MethodVisitor;
import mockit.asm.ReferenceType;
import mockit.internal.BaseClassModifier;
import mockit.internal.faking.FakeBridge;
import mockit.internal.faking.FakeMethodBridge;
import mockit.internal.faking.FakeMethods;
import mockit.internal.util.ClassLoad;

final class FakedClassModifier
extends BaseClassModifier {
    private static final int ABSTRACT_OR_SYNTHETIC = 5120;
    @Nonnull
    private final FakeMethods fakeMethods;
    private final boolean useClassLoadingBridgeForUpdatingFakeState;
    @Nonnull
    private final Class<?> fakedClass;
    private FakeMethods.FakeMethod fakeMethod;
    private boolean isConstructor;

    FakedClassModifier(@Nonnull ClassReader cr, @Nonnull Class<?> realClass, @Nonnull MockUp<?> fake, @Nonnull FakeMethods fakeMethods) {
        super(cr);
        this.fakedClass = realClass;
        this.fakeMethods = fakeMethods;
        ClassLoader classLoaderOfRealClass = realClass.getClassLoader();
        this.useClassLoadingBridgeForUpdatingFakeState = ClassLoad.isClassLoaderWithNoDirectAccess(classLoaderOfRealClass);
        this.inferUseOfClassLoadingBridge(classLoaderOfRealClass, fake);
    }

    private void inferUseOfClassLoadingBridge(@Nullable ClassLoader classLoaderOfRealClass, @Nonnull Object fake) {
        this.setUseClassLoadingBridge(classLoaderOfRealClass);
        if (!this.useClassLoadingBridge && !Modifier.isPublic(fake.getClass().getModifiers())) {
            this.useClassLoadingBridge = true;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if ((access & 0x1400) != 0) {
            if (Modifier.isAbstract(access)) {
                this.fakeMethods.findMethod(access, name, desc, signature);
            }
            return this.cw.visitMethod(access, name, desc, signature, exceptions);
        }
        this.isConstructor = "<init>".equals(name);
        if (this.isConstructor && this.isFakedSuperclass() || !this.hasFake(access, name, desc, signature)) {
            return this.cw.visitMethod(access, name, desc, signature, exceptions);
        }
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        if (this.isConstructor) {
            this.generateCallToSuperConstructor();
        } else if (Modifier.isNative(this.methodAccess)) {
            this.generateCallToUpdateFakeState();
            this.generateCallToFakeMethod();
            this.generateMethodReturn();
            this.mw.visitMaxStack(1);
            return this.methodAnnotationsVisitor;
        }
        this.generateDynamicCallToFake();
        return this.copyOriginalImplementationCode(this.isConstructor);
    }

    private boolean hasFake(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature) {
        String fakeName = FakedClassModifier.getCorrespondingFakeName(name);
        this.fakeMethod = this.fakeMethods.findMethod(access, fakeName, desc, signature);
        return this.fakeMethod != null;
    }

    @Nonnull
    private static String getCorrespondingFakeName(@Nonnull String name) {
        if ("<init>".equals(name)) {
            return "$init";
        }
        if ("<clinit>".equals(name)) {
            return "$clinit";
        }
        return name;
    }

    private boolean isFakedSuperclass() {
        return this.fakedClass != this.fakeMethods.getRealClass();
    }

    private void generateDynamicCallToFake() {
        Label startOfRealImplementation = null;
        if (!Modifier.isStatic(this.methodAccess) && !this.isConstructor && this.isFakedSuperclass()) {
            Class<?> targetClass = this.fakeMethods.getRealClass();
            if (this.fakedClass.getClassLoader() == targetClass.getClassLoader()) {
                startOfRealImplementation = new Label();
                this.mw.visitVarInsn(25, 0);
                this.mw.visitTypeInsn(193, JavaType.getInternalName(targetClass));
                this.mw.visitJumpInsn(153, startOfRealImplementation);
            }
        }
        this.generateCallToUpdateFakeState();
        if (this.isConstructor) {
            this.generateConditionalCallForFakedConstructor();
        } else {
            this.generateConditionalCallForFakedMethod(startOfRealImplementation);
        }
    }

    private void generateCallToUpdateFakeState() {
        if (this.useClassLoadingBridgeForUpdatingFakeState) {
            this.generateCallToControlMethodThroughClassLoadingBridge();
            this.mw.visitTypeInsn(192, "java/lang/Boolean");
            this.mw.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        } else {
            this.mw.visitLdcInsn(this.fakeMethods.getFakeClassInternalName());
            this.mw.visitIntInsn(17, this.fakeMethod.getIndexForFakeState());
            this.mw.visitMethodInsn(184, "mockit/internal/state/TestRun", "updateFakeState", "(Ljava/lang/String;I)Z", false);
        }
    }

    private void generateCallToControlMethodThroughClassLoadingBridge() {
        this.generateCodeToObtainInstanceOfClassLoadingBridge(FakeBridge.MB);
        this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitInsn(1);
        this.generateCodeToCreateArrayOfObject(2);
        int i = 0;
        this.generateCodeToFillArrayElement(i++, this.fakeMethods.getFakeClassInternalName());
        this.generateCodeToFillArrayElement(i, this.fakeMethod.getIndexForFakeState());
        this.generateCallToInvocationHandler();
    }

    private void generateConditionalCallForFakedMethod(@Nullable Label startOfRealImplementation) {
        if (startOfRealImplementation == null) {
            startOfRealImplementation = new Label();
        }
        this.mw.visitJumpInsn(153, startOfRealImplementation);
        this.generateCallToFakeMethod();
        this.generateMethodReturn();
        this.mw.visitLabel(startOfRealImplementation);
    }

    private void generateConditionalCallForFakedConstructor() {
        int jumpInsnOpcode;
        this.generateCallToFakeMethod();
        if (this.shouldUseClassLoadingBridge()) {
            this.mw.visitLdcInsn(VOID_TYPE);
            jumpInsnOpcode = 165;
        } else {
            jumpInsnOpcode = this.fakeMethod.hasInvocationParameter ? 154 : 153;
        }
        Label startOfRealImplementation = new Label();
        this.mw.visitJumpInsn(jumpInsnOpcode, startOfRealImplementation);
        this.mw.visitInsn(177);
        this.mw.visitLabel(startOfRealImplementation);
    }

    private void generateCallToFakeMethod() {
        if (this.shouldUseClassLoadingBridge()) {
            this.generateCallToFakeMethodThroughClassLoadingBridge();
        } else {
            this.generateDirectCallToFakeMethod();
        }
    }

    private boolean shouldUseClassLoadingBridge() {
        return this.useClassLoadingBridge || !this.fakeMethod.isPublic();
    }

    private void generateCallToFakeMethodThroughClassLoadingBridge() {
        this.generateCodeToObtainInstanceOfClassLoadingBridge(FakeMethodBridge.MB);
        boolean isStatic = this.generateCodeToPassThisOrNullIfStaticMethod();
        this.mw.visitInsn(1);
        JavaType[] argTypes = JavaType.getArgumentTypes(this.methodDesc);
        this.generateCodeToCreateArrayOfObject(6 + argTypes.length);
        int i = 0;
        this.generateCodeToFillArrayElement(i++, this.fakeMethods.getFakeClassInternalName());
        this.generateCodeToFillArrayElement(i++, this.classDesc);
        this.generateCodeToFillArrayElement(i++, this.methodAccess);
        if (this.fakeMethod.isAdvice) {
            this.generateCodeToFillArrayElement(i++, this.methodName);
            this.generateCodeToFillArrayElement(i++, this.methodDesc);
        } else {
            this.generateCodeToFillArrayElement(i++, this.fakeMethod.name);
            this.generateCodeToFillArrayElement(i++, this.fakeMethod.desc);
        }
        this.generateCodeToFillArrayElement(i++, this.fakeMethod.getIndexForFakeState());
        this.generateCodeToFillArrayWithParameterValues(argTypes, i, isStatic ? 0 : 1);
        this.generateCallToInvocationHandler();
    }

    private void generateDirectCallToFakeMethod() {
        int invokeOpcode;
        String fakeClassDesc = this.fakeMethods.getFakeClassInternalName();
        if (this.fakeMethod.isStatic()) {
            invokeOpcode = 184;
        } else {
            this.generateCodeToObtainFakeInstance(fakeClassDesc);
            invokeOpcode = 182;
        }
        boolean canProceedIntoConstructor = this.generateArgumentsForFakeMethodInvocation();
        this.mw.visitMethodInsn(invokeOpcode, fakeClassDesc, this.fakeMethod.name, this.fakeMethod.desc, false);
        if (canProceedIntoConstructor) {
            this.mw.visitMethodInsn(182, "mockit/internal/faking/FakeInvocation", "shouldProceedIntoConstructor", "()Z", false);
        }
    }

    private void generateCodeToObtainFakeInstance(@Nonnull String fakeClassDesc) {
        this.mw.visitLdcInsn(fakeClassDesc);
        this.mw.visitMethodInsn(184, "mockit/internal/state/TestRun", "getFake", "(Ljava/lang/String;)Ljava/lang/Object;", false);
        this.mw.visitTypeInsn(192, fakeClassDesc);
    }

    private boolean generateArgumentsForFakeMethodInvocation() {
        String fakedDesc = this.fakeMethod.isAdvice ? this.methodDesc : this.fakeMethod.fakeDescWithoutInvocationParameter;
        JavaType[] argTypes = JavaType.getArgumentTypes(fakedDesc);
        int varIndex = Modifier.isStatic(this.methodAccess) ? 0 : 1;
        boolean canProceedIntoConstructor = false;
        if (this.fakeMethod.hasInvocationParameter) {
            this.generateCallToCreateNewFakeInvocation(argTypes, varIndex);
            if (this.isConstructor) {
                this.mw.visitInsn(this.fakeMethod.isStatic() ? 89 : 90);
                canProceedIntoConstructor = true;
            }
        }
        if (!this.fakeMethod.isAdvice) {
            boolean forGenericMethod = this.fakeMethod.isForGenericMethod();
            for (JavaType argType : argTypes) {
                int opcode = argType.getOpcode(21);
                this.mw.visitVarInsn(opcode, varIndex);
                if (forGenericMethod && argType instanceof ReferenceType) {
                    String typeDesc = ((ReferenceType)argType).getInternalName();
                    this.mw.visitTypeInsn(192, typeDesc);
                }
                varIndex += argType.getSize();
            }
        }
        return canProceedIntoConstructor;
    }

    private void generateCallToCreateNewFakeInvocation(@Nonnull JavaType[] argTypes, @Nonnegative int initialParameterIndex) {
        this.generateCodeToPassThisOrNullIfStaticMethod();
        int argCount = argTypes.length;
        if (argCount == 0) {
            this.mw.visitInsn(1);
        } else {
            this.generateCodeToCreateArrayOfObject(argCount);
            this.generateCodeToFillArrayWithParameterValues(argTypes, 0, initialParameterIndex);
        }
        this.mw.visitLdcInsn(this.fakeMethods.getFakeClassInternalName());
        this.mw.visitIntInsn(17, this.fakeMethod.getIndexForFakeState());
        this.mw.visitLdcInsn(this.classDesc);
        this.mw.visitLdcInsn(this.methodName);
        this.mw.visitLdcInsn(this.methodDesc);
        this.mw.visitMethodInsn(184, "mockit/internal/faking/FakeInvocation", "create", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lmockit/internal/faking/FakeInvocation;", false);
    }

    private void generateMethodReturn() {
        if (this.shouldUseClassLoadingBridge() || this.fakeMethod.isAdvice) {
            this.generateReturnWithObjectAtTopOfTheStack(this.methodDesc);
        } else {
            JavaType returnType = JavaType.getReturnType(this.methodDesc);
            this.mw.visitInsn(returnType.getOpcode(172));
        }
    }
}

