/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassLoadingBridge;
import mockit.internal.faking.FakeState;
import mockit.internal.faking.FakeStates;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;

final class FakeMethods {
    @Nonnull
    private final Class<?> realClass;
    private final boolean targetTypeIsAClass;
    private final boolean reentrantRealClass;
    @Nonnull
    private final List<FakeMethod> methods;
    @Nullable
    private FakeMethod adviceMethod;
    @Nonnull
    private final GenericTypeReflection typeParametersToTypeArguments;
    @Nonnull
    private String fakeClassInternalName;
    @Nullable
    private List<FakeState> fakeStates;

    FakeMethods(@Nonnull Class<?> realClass, @Nullable Type targetType) {
        Class<?> targetClass;
        this.realClass = realClass;
        this.targetTypeIsAClass = targetType == null || realClass == targetType ? true : !(targetClass = Utilities.getClassType(targetType)).isInterface();
        this.reentrantRealClass = this.targetTypeIsAClass && ClassLoadingBridge.instanceOfClassThatParticipatesInClassLoading(realClass);
        this.methods = new ArrayList<FakeMethod>();
        this.typeParametersToTypeArguments = new GenericTypeReflection(realClass, targetType);
        this.fakeClassInternalName = "";
    }

    @Nonnull
    Class<?> getRealClass() {
        return this.realClass;
    }

    @Nullable
    FakeMethod addMethod(boolean fromSuperClass, int access, @Nonnull String name, @Nonnull String desc) {
        if (fromSuperClass && this.isMethodAlreadyAdded(name, desc)) {
            return null;
        }
        FakeMethod fakeMethod = new FakeMethod(access, name, desc);
        if (fakeMethod.isAdvice) {
            this.adviceMethod = fakeMethod;
        } else {
            this.methods.add(fakeMethod);
        }
        return fakeMethod;
    }

    private boolean isMethodAlreadyAdded(@Nonnull String name, @Nonnull String desc) {
        int p = desc.lastIndexOf(41);
        String params = desc.substring(0, p + 1);
        for (FakeMethod fakeMethod : this.methods) {
            if (!fakeMethod.name.equals(name) || !fakeMethod.desc.startsWith(params)) continue;
            return true;
        }
        return false;
    }

    void addFakeState(@Nonnull FakeState fakeState) {
        if (this.fakeStates == null) {
            this.fakeStates = new ArrayList<FakeState>(4);
        }
        fakeState.fakeMethod.indexForFakeState = this.fakeStates.size();
        this.fakeStates.add(fakeState);
    }

    @Nullable
    FakeMethod findMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature) {
        for (FakeMethod fakeMethod : this.methods) {
            if (!fakeMethod.isMatch(access, name, desc, signature)) continue;
            return fakeMethod;
        }
        if (!(this.adviceMethod == null || Modifier.isNative(access) || "$init".equals(name) || "$clinit".equals(name) || ObjectMethods.isMethodFromObject(name, desc))) {
            return this.adviceMethod;
        }
        return null;
    }

    @Nonnull
    String getFakeClassInternalName() {
        return this.fakeClassInternalName;
    }

    void setFakeClassInternalName(@Nonnull String fakeClassInternalName) {
        this.fakeClassInternalName = fakeClassInternalName.intern();
    }

    boolean hasUnusedFakes() {
        if (this.adviceMethod != null) {
            return true;
        }
        for (FakeMethod method : this.methods) {
            if (method.hasMatchingRealMethod) continue;
            return true;
        }
        return false;
    }

    void registerFakeStates(@Nonnull Object fake, boolean forStartupFake) {
        if (this.fakeStates != null) {
            FakeStates allFakeStates = TestRun.getFakeStates();
            if (forStartupFake) {
                allFakeStates.addStartupFakeAndItsFakeStates(fake, this.fakeStates);
            } else {
                allFakeStates.addFakeAndItsFakeStates(fake, this.fakeStates);
            }
        }
    }

    final class FakeMethod {
        private final int access;
        @Nonnull
        final String name;
        @Nonnull
        final String desc;
        final boolean isAdvice;
        final boolean hasInvocationParameter;
        @Nonnull
        final String fakeDescWithoutInvocationParameter;
        private boolean hasMatchingRealMethod;
        @Nullable
        private GenericTypeReflection.GenericSignature fakeSignature;
        private int indexForFakeState;
        private boolean nativeRealMethod;

        private FakeMethod(@Nonnull int access, @Nonnull String name, String desc) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            if (desc.contains("Lmockit/Invocation;")) {
                this.hasInvocationParameter = true;
                this.fakeDescWithoutInvocationParameter = '(' + desc.substring(20);
                this.isAdvice = "$advice".equals(name) && "()Ljava/lang/Object;".equals(this.fakeDescWithoutInvocationParameter);
            } else {
                this.hasInvocationParameter = false;
                this.fakeDescWithoutInvocationParameter = desc;
                this.isAdvice = false;
            }
            this.hasMatchingRealMethod = false;
            this.indexForFakeState = -1;
        }

        boolean isMatch(int realAccess, @Nonnull String realName, @Nonnull String realDesc, @Nullable String signature) {
            if (this.name.equals(realName) && this.hasMatchingParameters(realDesc, signature)) {
                this.hasMatchingRealMethod = true;
                this.nativeRealMethod = Modifier.isNative(realAccess);
                return true;
            }
            return false;
        }

        private boolean hasMatchingParameters(@Nonnull String methodDesc, @Nullable String signature) {
            boolean sameParametersIgnoringGenerics = this.fakeDescWithoutInvocationParameter.equals(methodDesc);
            if (sameParametersIgnoringGenerics || signature == null) {
                return sameParametersIgnoringGenerics;
            }
            if (this.fakeSignature == null) {
                this.fakeSignature = FakeMethods.this.typeParametersToTypeArguments.parseSignature(this.fakeDescWithoutInvocationParameter);
            }
            return this.fakeSignature.satisfiesGenericSignature(signature);
        }

        @Nonnull
        Class<?> getRealClass() {
            return FakeMethods.this.realClass;
        }

        @Nonnull
        String getFakeNameAndDesc() {
            return this.name + this.desc;
        }

        int getIndexForFakeState() {
            return this.indexForFakeState;
        }

        boolean isStatic() {
            return Modifier.isStatic(this.access);
        }

        boolean isPublic() {
            return Modifier.isPublic(this.access);
        }

        boolean isForGenericMethod() {
            return this.fakeSignature != null;
        }

        boolean isForNativeMethod() {
            return this.nativeRealMethod;
        }

        boolean requiresFakeState() {
            return this.hasInvocationParameter || FakeMethods.this.reentrantRealClass;
        }

        boolean canBeReentered() {
            return FakeMethods.this.targetTypeIsAClass && !this.nativeRealMethod;
        }

        public boolean equals(Object obj) {
            FakeMethod other = (FakeMethod)obj;
            return FakeMethods.this.realClass == other.getRealClass() && this.name.equals(other.name) && this.desc.equals(other.desc);
        }

        public int hashCode() {
            return 31 * (31 * FakeMethods.this.realClass.hashCode() + this.name.hashCode()) + this.desc.hashCode();
        }
    }
}

