/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.faking;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import mockit.MockUp;
import mockit.asm.ClassMetadataReader;
import mockit.asm.JavaType;
import mockit.internal.ClassFile;
import mockit.internal.faking.FakeMethods;
import mockit.internal.faking.FakeState;
import mockit.internal.util.ClassLoad;

final class FakeMethodCollector {
    private static final int INVALID_METHOD_ACCESSES = 5440;
    private static final EnumSet<ClassMetadataReader.Attribute> ANNOTATIONS = EnumSet.of(ClassMetadataReader.Attribute.Annotations);
    @Nonnull
    private final FakeMethods fakeMethods;
    private boolean collectingFromSuperClass;

    FakeMethodCollector(@Nonnull FakeMethods fakeMethods) {
        this.fakeMethods = fakeMethods;
    }

    void collectFakeMethods(@Nonnull Class<?> fakeClass) {
        ClassLoad.registerLoadedClass(fakeClass);
        this.fakeMethods.setFakeClassInternalName(JavaType.getInternalName(fakeClass));
        Class<?> classToCollectFakesFrom = fakeClass;
        do {
            byte[] classfileBytes = ClassFile.readBytesFromClassFile(classToCollectFakesFrom);
            ClassMetadataReader cmr = new ClassMetadataReader(classfileBytes, ANNOTATIONS);
            List<ClassMetadataReader.MethodInfo> methods = cmr.getMethods();
            this.addFakeMethods(methods);
            classToCollectFakesFrom = classToCollectFakesFrom.getSuperclass();
            this.collectingFromSuperClass = true;
        } while (classToCollectFakesFrom != MockUp.class);
    }

    private void addFakeMethods(@Nonnull List<ClassMetadataReader.MethodInfo> methods) {
        for (ClassMetadataReader.MethodInfo method : methods) {
            FakeMethods.FakeMethod fakeMethod;
            int access = method.accessFlags;
            String methodName = method.name;
            String methodDesc = method.desc;
            if ((access & 0x1540) != 0 || "<init>".equals(methodName) || !method.hasAnnotation("Lmockit/Mock;") || (fakeMethod = this.fakeMethods.addMethod(this.collectingFromSuperClass, access, methodName, methodDesc)) == null || !fakeMethod.requiresFakeState()) continue;
            FakeState fakeState = new FakeState(fakeMethod);
            this.fakeMethods.addFakeState(fakeState);
        }
    }
}

