/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ReferenceType;
import mockit.internal.expectations.transformation.Capture;
import mockit.internal.expectations.transformation.InvocationBlockModifier;

public final class ArgumentCapturing {
    private static final Map<Integer, String> varIndexToTypeDesc = new HashMap<Integer, String>();
    @Nonnull
    private final InvocationBlockModifier modifier;
    @Nullable
    private List<Capture> captures;
    private boolean parameterForCapture;
    @Nullable
    private String capturedTypeDesc;

    ArgumentCapturing(@Nonnull InvocationBlockModifier modifier) {
        this.modifier = modifier;
    }

    boolean registerMatcher(boolean withCaptureMethod, @Nonnull String methodDesc, @Nonnegative int lastLoadedVarIndex) {
        if (withCaptureMethod && "(Ljava/lang/Object;)Ljava/util/List;".equals(methodDesc)) {
            return false;
        }
        if (withCaptureMethod) {
            if (methodDesc.contains("List")) {
                if (lastLoadedVarIndex > 0) {
                    int parameterIndex = this.modifier.argumentMatching.getMatcherCount();
                    Capture capture = new Capture(this.modifier, lastLoadedVarIndex, parameterIndex);
                    this.addCapture(capture);
                }
                this.parameterForCapture = false;
            } else {
                this.parameterForCapture = true;
            }
        } else {
            this.parameterForCapture = false;
        }
        return true;
    }

    void registerTypeToCaptureIfApplicable(@Nonnegative int opcode, @Nonnull String typeDesc) {
        if (opcode == 192 && this.parameterForCapture) {
            this.capturedTypeDesc = typeDesc;
        }
    }

    static void registerTypeToCaptureIntoListIfApplicable(@Nonnegative int varIndex, @Nonnull String signature) {
        if (signature.startsWith("Ljava/util/List<")) {
            String typeDesc = signature.substring(16, signature.length() - 2);
            int p = typeDesc.indexOf(60);
            if (p > 0) {
                typeDesc = typeDesc.substring(0, p) + ';';
            }
            ReferenceType type = ReferenceType.createFromTypeDescriptor(typeDesc);
            varIndexToTypeDesc.put(varIndex, type.getInternalName());
        }
    }

    void registerAssignmentToCaptureVariableIfApplicable(@Nonnegative int opcode, @Nonnegative int varIndex) {
        if (opcode >= 54 && opcode <= 58 && this.parameterForCapture) {
            int parameterIndex = this.modifier.argumentMatching.getMatcherCount() - 1;
            Capture capture = new Capture(this.modifier, opcode, varIndex, this.capturedTypeDesc, parameterIndex);
            this.addCapture(capture);
            this.parameterForCapture = false;
            this.capturedTypeDesc = null;
        }
    }

    private void addCapture(@Nonnull Capture capture) {
        if (this.captures == null) {
            this.captures = new ArrayList<Capture>();
        }
        this.captures.add(capture);
    }

    void updateCaptureIfAny(@Nonnegative int originalIndex, @Nonnegative int newIndex) {
        if (this.captures != null) {
            Capture capture;
            for (int i = this.captures.size() - 1; i >= 0 && !(capture = this.captures.get(i)).fixParameterIndex(originalIndex, newIndex); --i) {
            }
        }
    }

    void generateCallsToSetArgumentTypesToCaptureIfAny() {
        if (this.captures != null) {
            for (Capture capture : this.captures) {
                capture.generateCallToSetArgumentTypeIfNeeded();
            }
        }
    }

    void generateCallsToCaptureMatchedArgumentsIfPending() {
        if (this.captures != null) {
            for (Capture capture : this.captures) {
                capture.generateCodeToStoreCapturedValue();
            }
            this.captures = null;
        }
    }

    @Nullable
    public static String extractArgumentType(@Nonnegative int varIndex) {
        return varIndexToTypeDesc.remove(varIndex);
    }
}

