/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ClassReader;
import mockit.asm.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.expectations.mocking.MockedClassModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.startup.Startup;
import mockit.internal.state.MockFixture;
import mockit.internal.state.TestRun;

public final class CaptureOfNewInstances
extends CaptureOfImplementations<MockedType> {
    @Nonnull
    private final List<Class<?>> baseTypes = new ArrayList();
    @Nonnull
    private final List<Class<?>> partiallyMockedBaseTypes = new ArrayList();

    CaptureOfNewInstances() {
    }

    void useDynamicMocking(@Nonnull Class<?> baseType) {
        this.partiallyMockedBaseTypes.add(baseType);
        List<Class<?>> mockedClasses = TestRun.mockFixture().getMockedClasses();
        for (Class<?> mockedClass : mockedClasses) {
            if (!baseType.isAssignableFrom(mockedClass) || mockedClass == baseType && baseType.isInterface()) continue;
            CaptureOfNewInstances.redefineClassForDynamicPartialMocking(baseType, mockedClass);
        }
    }

    private static void redefineClassForDynamicPartialMocking(@Nonnull Class<?> baseType, @Nonnull Class<?> mockedClass) {
        ClassReader classReader = ClassFile.createReaderOrGetFromCache(mockedClass);
        MockedClassModifier modifier = CaptureOfNewInstances.newModifier(mockedClass.getClassLoader(), classReader, baseType, null);
        modifier.useDynamicMocking(true);
        classReader.accept(modifier);
        byte[] modifiedClassfile = modifier.toByteArray();
        Startup.redefineMethods(mockedClass, modifiedClassfile);
    }

    @Nonnull
    private static MockedClassModifier newModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, @Nullable MockedType typeMetadata) {
        MockedClassModifier modifier = new MockedClassModifier(cl, cr, typeMetadata);
        String baseTypeDesc = JavaType.getInternalName(baseType);
        modifier.setClassNameForCapturedInstanceMethods(baseTypeDesc);
        return modifier;
    }

    @Override
    @Nonnull
    protected BaseClassModifier createModifier(@Nullable ClassLoader cl, @Nonnull ClassReader cr, @Nonnull Class<?> baseType, @Nullable MockedType typeMetadata) {
        MockedClassModifier modifier = CaptureOfNewInstances.newModifier(cl, cr, baseType, typeMetadata);
        if (this.partiallyMockedBaseTypes.contains(baseType)) {
            modifier.useDynamicMocking(true);
        }
        return modifier;
    }

    @Override
    protected void redefineClass(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        ClassDefinition newClassDefinition = new ClassDefinition(realClass, modifiedClass);
        Startup.redefineMethods(newClassDefinition);
        MockFixture mockFixture = TestRun.mockFixture();
        mockFixture.addRedefinedClass(newClassDefinition);
        mockFixture.registerMockedClass(realClass);
    }

    void registerCaptureOfNewInstances(@Nonnull MockedType typeMetadata) {
        Class<?> baseType = typeMetadata.getClassType();
        if (!typeMetadata.isFinalFieldOrParameter()) {
            this.makeSureAllSubtypesAreModified(typeMetadata);
        }
        if (!this.baseTypes.contains(baseType)) {
            this.baseTypes.add(baseType);
        }
    }

    void makeSureAllSubtypesAreModified(@Nonnull MockedType typeMetadata) {
        Class<?> baseType = typeMetadata.getClassType();
        this.makeSureAllSubtypesAreModified(baseType, typeMetadata.fieldFromTestClass, typeMetadata);
    }

    public boolean captureNewInstance(@Nonnull Object mock) {
        Class<?> mockedClass = mock.getClass();
        return !this.baseTypes.contains(mockedClass) && this.isWithCapturing(mockedClass);
    }

    private boolean isWithCapturing(@Nonnull Class<?> mockedClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = mockedClass.getInterfaces()) {
            if (!this.baseTypes.contains(anInterface)) continue;
            return true;
        }
        Class<?> superclass = mockedClass.getSuperclass();
        return superclass != Object.class && (this.baseTypes.contains(superclass) || this.isWithCapturing(superclass));
    }

    void cleanUp() {
        this.baseTypes.clear();
        this.partiallyMockedBaseTypes.clear();
    }
}

