/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;

final class ReplayPhase
extends Phase {
    @Nonnull
    final List<Expectation> invocations = new ArrayList<Expectation>();
    @Nonnull
    final List<Object> invocationInstances = new ArrayList<Object>();
    @Nonnull
    final List<Object[]> invocationArguments = new ArrayList<Object[]>();

    ReplayPhase(@Nonnull RecordAndReplayExecution recordAndReplay) {
        super(recordAndReplay);
    }

    @Override
    @Nullable
    Object handleInvocation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        Object replacementInstance;
        Expectation expectation = this.recordAndReplay.executionState.findExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        Object object = replacementInstance = mock == null ? null : this.recordAndReplay.executionState.getReplacementInstanceForMethodInvocation(mock, mockNameAndDesc);
        if (expectation == null) {
            expectation = this.createExpectation(replacementInstance == null ? mock : replacementInstance, mockAccess, mockClassDesc, mockNameAndDesc, genericSignature, args);
        } else if (expectation.recordPhase != null) {
            this.registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(mock, expectation.invocation);
        }
        this.invocations.add(expectation);
        this.invocationInstances.add(mock);
        this.invocationArguments.add(args);
        expectation.constraints.incrementInvocationCount();
        if (withRealImpl && replacementInstance != null) {
            return this.produceResult(expectation, replacementInstance, args);
        }
        return this.produceResult(expectation, mock, withRealImpl, args);
    }

    @Nonnull
    private Expectation createExpectation(@Nullable Object mock, int mockAccess, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nullable String genericSignature, @Nonnull Object[] args) {
        ExpectedInvocation invocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, false, genericSignature, args);
        Expectation expectation = new Expectation(invocation);
        this.recordAndReplay.executionState.addExpectation(expectation);
        return expectation;
    }

    private void registerNewInstanceAsEquivalentToOneFromRecordedConstructorInvocation(@Nullable Object mock, @Nonnull ExpectedInvocation invocation) {
        if (mock != null && invocation.isConstructor()) {
            Map<Object, Object> instanceMap = this.getInstanceMap();
            Object recordedInstance = invocation.getRecordedInstance();
            instanceMap.put(mock, recordedInstance);
        }
    }

    @Nullable
    private Object produceResult(@Nonnull Expectation expectation, @Nonnull Object replacementInstance, @Nonnull Object[] args) throws Throwable {
        if (expectation.recordPhase == null) {
            expectation.executedRealImplementation = true;
        } else if (expectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
            this.recordAndReplay.setErrorThrown(expectation.invocation.errorForUnexpectedInvocation(args));
            return null;
        }
        return expectation.executeRealImplementation(replacementInstance, args);
    }

    @Nullable
    private Object produceResult(@Nonnull Expectation expectation, @Nullable Object mock, boolean withRealImpl, @Nonnull Object[] args) throws Throwable {
        boolean executeRealImpl;
        boolean bl = executeRealImpl = withRealImpl && expectation.recordPhase == null;
        if (executeRealImpl) {
            expectation.executedRealImplementation = true;
            return Void.class;
        }
        if (expectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
            this.recordAndReplay.setErrorThrown(expectation.invocation.errorForUnexpectedInvocation(args));
            return null;
        }
        return expectation.produceResult(mock, args);
    }

    @Nullable
    private Object handleUnexpectedInvocation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, boolean withRealImpl, @Nonnull Object[] replayArgs) {
        if (withRealImpl) {
            return Void.class;
        }
        this.recordAndReplay.setErrorThrown(new ExpectedInvocation(mock, mockClassDesc, mockNameAndDesc, replayArgs).errorForUnexpectedInvocation());
        return null;
    }

    @Nullable
    Error endExecution() {
        Error missingInvocation = this.getErrorForFirstExpectationThatIsMissing();
        return missingInvocation;
    }

    @Nullable
    private Error getErrorForFirstExpectationThatIsMissing() {
        List<Expectation> notStrictExpectations = this.recordAndReplay.executionState.expectations;
        int n = notStrictExpectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation notStrict = notStrictExpectations.get(i);
            InvocationConstraints constraints = notStrict.constraints;
            if (!constraints.isInvocationCountLessThanMinimumExpected()) continue;
            List<ExpectedInvocation> nonMatchingInvocations = this.getNonMatchingInvocations(notStrict);
            return constraints.errorForMissingExpectations(notStrict.invocation, nonMatchingInvocations);
        }
        return null;
    }

    @Nonnull
    private List<ExpectedInvocation> getNonMatchingInvocations(@Nonnull Expectation unsatisfiedExpectation) {
        ExpectedInvocation unsatisfiedInvocation = unsatisfiedExpectation.invocation;
        ArrayList<ExpectedInvocation> nonMatchingInvocations = new ArrayList<ExpectedInvocation>();
        for (Expectation replayedExpectation : this.invocations) {
            ExpectedInvocation replayedInvocation = replayedExpectation.invocation;
            if (replayedExpectation == unsatisfiedExpectation || !replayedInvocation.isMatch(unsatisfiedInvocation)) continue;
            nonMatchingInvocations.add(replayedInvocation);
        }
        return nonMatchingInvocations;
    }
}

