/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Expectations;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.ExecutionMode;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.FailureState;
import mockit.internal.expectations.OrderedVerificationPhase;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.PhasedExecutionState;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.UnorderedVerificationPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.DynamicPartialMocking;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.state.ExecutingTest;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassNaming;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;

public final class RecordAndReplayExecution {
    public static final ReentrantLock RECORD_OR_REPLAY_LOCK = new ReentrantLock();
    public static final ReentrantLock TEST_ONLY_PHASE_LOCK = new ReentrantLock();
    @Nullable
    private final DynamicPartialMocking dynamicPartialMocking;
    @Nonnull
    final PhasedExecutionState executionState;
    @Nonnull
    private final FailureState failureState;
    @Nullable
    private RecordPhase recordPhase;
    @Nullable
    private ReplayPhase replayPhase;
    @Nullable
    private BaseVerificationPhase verificationPhase;

    public RecordAndReplayExecution() {
        this.executionState = new PhasedExecutionState();
        this.dynamicPartialMocking = null;
        this.discoverMockedTypesAndInstancesForMatchingOnInstance();
        this.failureState = new FailureState();
        this.replayPhase = new ReplayPhase(this);
    }

    public RecordAndReplayExecution(@Nonnull Expectations targetObject, Object ... classesOrInstancesToBePartiallyMocked) {
        TestRun.enterNoMockingZone();
        ExecutingTest executingTest = TestRun.getExecutingTest();
        executingTest.setShouldIgnoreMockingCallbacks(true);
        try {
            RecordAndReplayExecution previous = executingTest.getPreviousRecordAndReplay();
            this.executionState = previous == null ? new PhasedExecutionState() : previous.executionState;
            this.failureState = new FailureState();
            this.recordPhase = new RecordPhase(this);
            executingTest.setRecordAndReplay(this);
            this.dynamicPartialMocking = RecordAndReplayExecution.applyDynamicPartialMocking(classesOrInstancesToBePartiallyMocked);
            this.discoverMockedTypesAndInstancesForMatchingOnInstance();
            TEST_ONLY_PHASE_LOCK.lock();
        }
        catch (RuntimeException e) {
            executingTest.setRecordAndReplay(null);
            throw e;
        }
        finally {
            executingTest.setShouldIgnoreMockingCallbacks(false);
            TestRun.exitNoMockingZone();
        }
    }

    private void discoverMockedTypesAndInstancesForMatchingOnInstance() {
        FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
        if (fieldTypeRedefinitions != null) {
            List<Class<?>> fields = fieldTypeRedefinitions.getTargetClasses();
            ArrayList targetClasses = new ArrayList(fields);
            ParameterTypeRedefinitions paramTypeRedefinitions = TestRun.getExecutingTest().getParameterRedefinitions();
            if (paramTypeRedefinitions != null) {
                targetClasses.addAll(paramTypeRedefinitions.getTargetClasses());
            }
            this.executionState.discoverMockedTypesToMatchOnInstances(targetClasses);
            if (this.dynamicPartialMocking != null && !this.dynamicPartialMocking.targetInstances.isEmpty()) {
                this.executionState.setDynamicMockInstancesToMatch(this.dynamicPartialMocking.targetInstances);
            }
        }
    }

    @Nullable
    private static DynamicPartialMocking applyDynamicPartialMocking(Object ... classesOrInstances) {
        if (classesOrInstances == null || classesOrInstances.length == 0) {
            return null;
        }
        DynamicPartialMocking mocking = new DynamicPartialMocking();
        mocking.redefineTypes(classesOrInstances);
        return mocking;
    }

    @Nullable
    public RecordPhase getRecordPhase() {
        return this.recordPhase;
    }

    @Nullable
    Error getErrorThrown() {
        return this.failureState.getErrorThrown();
    }

    void setErrorThrown(@Nullable Error error) {
        this.failureState.setErrorThrown(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object recordOrReplay(@Nullable Object mock, int mockAccess, @Nonnull String classDesc, @Nonnull String mockDesc, @Nullable String genericSignature, int executionModeOrdinal, @Nullable Object[] args) throws Throwable {
        if (Utilities.calledFromSpecialThread()) {
            return RecordAndReplayExecution.proceedIntoRealImplementationOrGetDefaultReturnType(mock, mockAccess, mockDesc, genericSignature);
        }
        if (args == null) {
            args = Utilities.NO_ARGS;
        }
        ExecutionMode executionMode = ExecutionMode.values()[executionModeOrdinal];
        if (RECORD_OR_REPLAY_LOCK.isHeldByCurrentThread() || TEST_ONLY_PHASE_LOCK.isLocked() && !TEST_ONLY_PHASE_LOCK.isHeldByCurrentThread() || !TestRun.mockFixture().isStillMocked(mock, classDesc)) {
            return RecordAndReplayExecution.defaultReturnValue(mock, classDesc, mockDesc, genericSignature, executionMode, args);
        }
        ExecutingTest executingTest = TestRun.getExecutingTest();
        if (executingTest.isShouldIgnoreMockingCallbacks()) {
            return RecordAndReplayExecution.defaultReturnValue(executingTest, mock, classDesc, mockDesc, genericSignature, executionMode, args);
        }
        if (executingTest.shouldProceedIntoRealImplementation(mock, classDesc) || executionMode.isToExecuteRealImplementation(mock)) {
            return Void.class;
        }
        RECORD_OR_REPLAY_LOCK.lock();
        try {
            boolean isConstructor = mock != null && mockDesc.startsWith("<init>");
            RecordAndReplayExecution instance = executingTest.getOrCreateRecordAndReplay();
            if (isConstructor && RecordAndReplayExecution.handleCallToConstructor(instance, mock, classDesc)) {
                Class<Void> clazz = executionMode == ExecutionMode.Regular || executionMode == ExecutionMode.Partial && instance.replayPhase == null || executingTest.isInjectableMock(mock) ? null : Void.class;
                return clazz;
            }
            Phase currentPhase = instance.getCurrentPhase();
            instance.failureState.clearErrorThrown();
            boolean withRealImpl = executionMode.isWithRealImplementation(mock);
            Object result = currentPhase.handleInvocation(mock, mockAccess, classDesc, mockDesc, genericSignature, withRealImpl, args);
            instance.failureState.reportErrorThrownIfAny();
            Object object = result;
            return object;
        }
        finally {
            RECORD_OR_REPLAY_LOCK.unlock();
        }
    }

    @Nullable
    private static Object proceedIntoRealImplementationOrGetDefaultReturnType(@Nullable Object mock, int mockAccess, @Nonnull String mockDesc, @Nullable String genericSignature) {
        Class<?> mockedClass;
        String mockedClassName;
        if (mock != null && (GeneratedClasses.isGeneratedImplementationClass(mockedClassName = (mockedClass = mock.getClass()).getName()) || Modifier.isAbstract(mockAccess) && GeneratedClasses.isGeneratedSubclass(mockedClassName))) {
            if (genericSignature != null) {
                GenericTypeReflection typeReflection = new GenericTypeReflection(mockedClass, null);
                String typeDesc = typeReflection.resolveReturnType(genericSignature);
                return DefaultValues.computeForType(typeDesc);
            }
            return DefaultValues.computeForReturnType(mockDesc);
        }
        return Void.class;
    }

    @Nonnull
    private static Object defaultReturnValue(@Nullable Object mock, @Nonnull String classDesc, @Nonnull String nameAndDesc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode, @Nonnull Object[] args) {
        ExpectedInvocation invocation;
        Object cascadedInstance;
        Object rv;
        if (executionMode.isToExecuteRealImplementation(mock)) {
            return Void.class;
        }
        if (mock != null && (rv = ObjectMethods.evaluateOverride(mock, nameAndDesc, args)) != null) {
            return executionMode.isToExecuteRealObjectOverride(mock) ? Void.class : rv;
        }
        String returnTypeDesc = DefaultValues.getReturnTypeDesc(nameAndDesc);
        if (returnTypeDesc.charAt(0) == 'L' && (cascadedInstance = (invocation = new ExpectedInvocation(mock, classDesc, nameAndDesc, genericSignature, args)).getDefaultValueForReturnType()) != null) {
            return cascadedInstance;
        }
        return Void.class;
    }

    @Nullable
    private static Object defaultReturnValue(@Nonnull ExecutingTest executingTest, @Nullable Object mock, @Nonnull String classDesc, @Nonnull String nameAndDesc, @Nullable String genericSignature, @Nonnull ExecutionMode executionMode, @Nonnull Object[] args) throws Throwable {
        Expectation recordedExpectation;
        RecordAndReplayExecution execution = executingTest.getCurrentRecordAndReplay();
        if (execution != null && (recordedExpectation = execution.executionState.findExpectation(mock, classDesc, nameAndDesc, args)) != null) {
            return recordedExpectation.produceResult(mock, args);
        }
        return RecordAndReplayExecution.defaultReturnValue(mock, classDesc, nameAndDesc, genericSignature, executionMode, args);
    }

    private static boolean handleCallToConstructor(@Nonnull RecordAndReplayExecution instance, @Nonnull Object mock, @Nonnull String classDesc) {
        if (instance.replayPhase != null) {
            CaptureOfNewInstances paramTypeCaptures;
            ParameterTypeRedefinitions paramTypeRedefinitions = TestRun.getExecutingTest().getParameterRedefinitions();
            if (paramTypeRedefinitions != null && (paramTypeCaptures = paramTypeRedefinitions.getCaptureOfNewInstances()) != null && paramTypeCaptures.captureNewInstance(mock)) {
                return true;
            }
            FieldTypeRedefinitions fieldTypeRedefinitions = TestRun.getFieldTypeRedefinitions();
            if (fieldTypeRedefinitions != null && fieldTypeRedefinitions.captureNewInstanceForApplicableMockField(mock)) {
                return true;
            }
        }
        return RecordAndReplayExecution.isCallToSuperClassConstructor(mock, classDesc);
    }

    private static boolean isCallToSuperClassConstructor(@Nonnull Object mock, @Nonnull String calledClassDesc) {
        Class<?> mockedClass = mock.getClass();
        if (ClassNaming.isAnonymousClass(mockedClass) && (mockedClass = mockedClass.getSuperclass()) == Object.class) {
            return false;
        }
        String calledClassName = calledClassDesc.replace('/', '.');
        return !calledClassName.equals(mockedClass.getName());
    }

    @Nonnull
    private Phase getCurrentPhase() {
        ReplayPhase replay = this.replayPhase;
        if (replay == null) {
            RecordPhase record = this.recordPhase;
            assert (record != null);
            return record;
        }
        BaseVerificationPhase verification = this.verificationPhase;
        if (verification != null) {
            return verification;
        }
        return replay;
    }

    @Nonnull
    public BaseVerificationPhase startVerifications(boolean inOrder) {
        assert (this.replayPhase != null);
        List<Expectation> expectations = this.replayPhase.invocations;
        List<Object> invocationInstances = this.replayPhase.invocationInstances;
        List<Object[]> invocationArguments = this.replayPhase.invocationArguments;
        this.verificationPhase = inOrder ? new OrderedVerificationPhase(this, expectations, invocationInstances, invocationArguments) : new UnorderedVerificationPhase(this, expectations, invocationInstances, invocationArguments);
        return this.verificationPhase;
    }

    @Nullable
    public static Error endCurrentReplayIfAny() {
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest();
        return instance == null ? null : instance.endExecution();
    }

    @Nullable
    private Error endExecution() {
        ReplayPhase replay;
        Error error;
        if (TEST_ONLY_PHASE_LOCK.isLocked()) {
            TEST_ONLY_PHASE_LOCK.unlock();
        }
        if ((error = (replay = this.switchFromRecordToReplayIfNotYet()).endExecution()) == null) {
            error = this.failureState.getErrorThrownInAnotherThreadIfAny();
        }
        if (error == null && this.verificationPhase != null) {
            error = this.verificationPhase.endVerification();
            this.verificationPhase = null;
        }
        return error;
    }

    @Nonnull
    private ReplayPhase switchFromRecordToReplayIfNotYet() {
        if (this.replayPhase == null) {
            this.recordPhase = null;
            this.replayPhase = new ReplayPhase(this);
        }
        return this.replayPhase;
    }

    @Nullable
    public TestOnlyPhase getCurrentTestOnlyPhase() {
        if (this.recordPhase != null) {
            return this.recordPhase;
        }
        return this.verificationPhase;
    }

    void endInvocations() {
        TEST_ONLY_PHASE_LOCK.unlock();
        if (this.verificationPhase == null) {
            this.switchFromRecordToReplayIfNotYet();
        } else {
            Error error = this.verificationPhase.endVerification();
            this.verificationPhase = null;
            if (error != null) {
                throw error;
            }
        }
    }
}

