/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.state.TestRun;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;

final class PhasedExecutionState {
    @Nonnull
    final List<Expectation> expectations = new ArrayList<Expectation>();
    @Nonnull
    final List<VerifiedExpectation> verifiedExpectations = new ArrayList<VerifiedExpectation>();
    @Nonnull
    final Map<Object, Object> instanceMap = new IdentityHashMap<Object, Object>();
    @Nonnull
    final Map<Object, Object> replacementMap = new IdentityHashMap<Object, Object>();
    @Nullable
    private List<?> dynamicMockInstancesToMatch;
    @Nullable
    private List<Class<?>> mockedTypesToMatchOnInstances;

    PhasedExecutionState() {
    }

    void setDynamicMockInstancesToMatch(@Nonnull List<?> dynamicMockInstancesToMatch) {
        this.dynamicMockInstancesToMatch = dynamicMockInstancesToMatch;
    }

    void discoverMockedTypesToMatchOnInstances(@Nonnull List<Class<?>> targetClasses) {
        int numClasses = targetClasses.size();
        if (numClasses > 1) {
            for (int i = 0; i < numClasses; ++i) {
                Class<?> targetClass = targetClasses.get(i);
                if (targetClasses.lastIndexOf(targetClass) <= i) continue;
                this.addMockedTypeToMatchOnInstance(targetClass);
            }
        }
    }

    private void addMockedTypeToMatchOnInstance(@Nonnull Class<?> mockedType) {
        if (this.mockedTypesToMatchOnInstances == null) {
            this.mockedTypesToMatchOnInstances = new LinkedList();
        }
        if (!Utilities.containsReference(this.mockedTypesToMatchOnInstances, mockedType)) {
            this.mockedTypesToMatchOnInstances.add(mockedType);
        }
    }

    void addExpectation(@Nonnull Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        this.forceMatchingOnMockInstanceIfRequired(invocation);
        this.removeMatchingExpectationsCreatedBefore(invocation);
        this.expectations.add(expectation);
    }

    private void forceMatchingOnMockInstanceIfRequired(@Nonnull ExpectedInvocation invocation) {
        if (!invocation.matchInstance && this.isToBeMatchedOnInstance(invocation.instance, invocation.getMethodNameAndDescription())) {
            invocation.matchInstance = true;
        }
    }

    boolean isToBeMatchedOnInstance(@Nullable Object mock, @Nonnull String mockNameAndDesc) {
        Class<?> mockedClass;
        if (mock == null || mockNameAndDesc.charAt(0) == '<') {
            return false;
        }
        if (this.dynamicMockInstancesToMatch != null && Utilities.containsReference(this.dynamicMockInstancesToMatch, mock)) {
            return true;
        }
        if (this.mockedTypesToMatchOnInstances != null && Utilities.containsReference(this.mockedTypesToMatchOnInstances, mockedClass = GeneratedClasses.getMockedClass(mock))) {
            return true;
        }
        return TestRun.getExecutingTest().isInjectableMock(mock);
    }

    private void removeMatchingExpectationsCreatedBefore(@Nonnull ExpectedInvocation invocation) {
        Expectation previousExpectation = this.findPreviousExpectation(invocation);
        if (previousExpectation != null) {
            this.expectations.remove(previousExpectation);
            invocation.copyDefaultReturnValue(previousExpectation.invocation);
        }
    }

    @Nullable
    private Expectation findPreviousExpectation(@Nonnull ExpectedInvocation newInvocation) {
        int n = this.expectations.size();
        if (n == 0) {
            return null;
        }
        Object mock = newInvocation.instance;
        Boolean matchInstance = newInvocation.matchInstance;
        String mockClassDesc = newInvocation.getClassDesc();
        String mockNameAndDesc = newInvocation.getMethodNameAndDescription();
        boolean isConstructor = newInvocation.isConstructor();
        for (int i = 0; i < n; ++i) {
            Expectation previous = this.expectations.get(i);
            if (!this.isMatchingInvocation(mock, matchInstance, mockClassDesc, mockNameAndDesc, isConstructor, previous) || !this.isWithMatchingArguments(newInvocation, previous.invocation)) continue;
            return previous;
        }
        return null;
    }

    private boolean isMatchingInvocation(@Nullable Object mock, @Nullable Boolean matchInstance, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, boolean constructorInvocation, @Nonnull Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        return invocation.isMatch(mock, mockClassDesc, mockNameAndDesc) && PhasedExecutionState.isSameMockedClass(mock, invocation.instance) && (constructorInvocation || mock == null || this.isMatchingInstance(mock, matchInstance, expectation));
    }

    private static boolean isSameMockedClass(@Nullable Object mock1, @Nullable Object mock2) {
        if (mock1 == mock2) {
            return true;
        }
        if (mock1 != null && mock2 != null) {
            Class<?> mockedClass1 = mock1.getClass();
            Class<?> mockedClass2 = GeneratedClasses.getMockedClass(mock2);
            return mockedClass2.isAssignableFrom(mockedClass1) || TestRun.mockFixture().areCapturedClasses(mockedClass1, mockedClass2);
        }
        return false;
    }

    private boolean isWithMatchingArguments(@Nonnull ExpectedInvocation newInvocation, @Nonnull ExpectedInvocation previousInvocation) {
        InvocationArguments newArguments = newInvocation.arguments;
        InvocationArguments previousArguments = previousInvocation.arguments;
        if (newArguments.getMatchers() == null) {
            return previousArguments.isMatch(newArguments.getValues(), this.instanceMap);
        }
        return newArguments.hasEquivalentMatchers(previousArguments);
    }

    @Nullable
    Expectation findExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        boolean isConstructor = mockNameAndDesc.charAt(0) == '<';
        Expectation replayExpectationFound = null;
        int n = this.expectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation expectation = this.expectations.get(i);
            if (replayExpectationFound != null && expectation.recordPhase == null || !this.isMatchingInvocation(mock, null, mockClassDesc, mockNameAndDesc, isConstructor, expectation) || !expectation.invocation.arguments.isMatch(args, this.instanceMap)) continue;
            if (expectation.recordPhase == null) {
                replayExpectationFound = expectation;
                continue;
            }
            if (isConstructor) {
                this.registerReplacementInstanceIfApplicable(mock, expectation.invocation);
            }
            return expectation;
        }
        return replayExpectationFound;
    }

    private void registerReplacementInstanceIfApplicable(@Nullable Object mock, @Nonnull ExpectedInvocation invocation) {
        Object replacementInstance = invocation.replacementInstance;
        if (replacementInstance != null && replacementInstance != invocation.instance) {
            this.replacementMap.put(mock, replacementInstance);
        }
    }

    private boolean isMatchingInstance(@Nonnull Object invokedInstance, @Nullable Boolean matchInstance, @Nonnull Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        Object invocationInstance = invocation.instance;
        assert (invocationInstance != null);
        if (this.isEquivalentInstance(invocationInstance, invokedInstance)) {
            return true;
        }
        if (TestRun.getExecutingTest().isInjectableMock(invokedInstance) || this.isDynamicMockInstanceOrClass(invokedInstance, invocationInstance) || this.areNonEquivalentInstances(invocationInstance, invokedInstance)) {
            return false;
        }
        return (matchInstance == null || matchInstance == false) && !invocation.matchInstance && expectation.recordPhase != null && !this.replacementMap.containsValue(invocationInstance);
    }

    boolean isEquivalentInstance(@Nonnull Object invocationInstance, @Nonnull Object invokedInstance) {
        return invocationInstance == invokedInstance || invocationInstance == this.replacementMap.get(invokedInstance) || invocationInstance == this.instanceMap.get(invokedInstance) || invokedInstance == this.instanceMap.get(invocationInstance);
    }

    private boolean isDynamicMockInstanceOrClass(@Nonnull Object invokedInstance, @Nonnull Object invocationInstance) {
        if (this.dynamicMockInstancesToMatch != null) {
            if (Utilities.containsReference(this.dynamicMockInstancesToMatch, invokedInstance)) {
                return true;
            }
            Class<?> invokedClass = invocationInstance.getClass();
            for (Object dynamicMock : this.dynamicMockInstancesToMatch) {
                if (dynamicMock.getClass() != invokedClass) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areNonEquivalentInstances(@Nonnull Object invocationInstance, @Nonnull Object invokedInstance) {
        boolean recordedInstanceMatchingAnyInstance = !this.isMatchingInstance(invocationInstance);
        boolean invokedInstanceMatchingSpecificInstance = this.isMatchingInstance(invokedInstance);
        return recordedInstanceMatchingAnyInstance && invokedInstanceMatchingSpecificInstance;
    }

    private boolean isMatchingInstance(@Nonnull Object instance) {
        return this.instanceMap.containsKey(instance) || this.instanceMap.containsValue(instance) || this.replacementMap.containsKey(instance) || this.replacementMap.containsValue(instance);
    }

    boolean areInDifferentEquivalenceSets(@Nonnull Object mock1, @Nonnull Object mock2) {
        if (mock1 == mock2 || this.instanceMap.isEmpty()) {
            return false;
        }
        Object mock1Equivalent = this.instanceMap.get(mock1);
        Object mock2Equivalent = this.instanceMap.get(mock2);
        if (mock1Equivalent == mock2 || mock2Equivalent == mock1) {
            return false;
        }
        if (mock1Equivalent != null && mock2Equivalent != null) {
            return true;
        }
        return this.instanceMapHasMocksInSeparateEntries(mock1, mock2);
    }

    private boolean instanceMapHasMocksInSeparateEntries(@Nonnull Object mock1, @Nonnull Object mock2) {
        boolean found1 = false;
        boolean found2 = false;
        for (Map.Entry<Object, Object> entry : this.instanceMap.entrySet()) {
            if (!found1 && PhasedExecutionState.isInMapEntry(entry, mock1)) {
                found1 = true;
            }
            if (!found2 && PhasedExecutionState.isInMapEntry(entry, mock2)) {
                found2 = true;
            }
            if (!found1 || !found2) continue;
            return true;
        }
        return false;
    }

    private static boolean isInMapEntry(@Nonnull Map.Entry<Object, Object> mapEntry, @Nonnull Object mock) {
        return mapEntry.getKey() == mock || mapEntry.getValue() == mock;
    }

    @Nullable
    Object getReplacementInstanceForMethodInvocation(@Nonnull Object invokedInstance, @Nonnull String methodNameAndDesc) {
        return methodNameAndDesc.charAt(0) == '<' ? null : this.replacementMap.get(invokedInstance);
    }

    boolean isReplacementInstance(@Nonnull Object invokedInstance, @Nonnull String methodNameAndDesc) {
        return methodNameAndDesc.charAt(0) != '<' && (this.replacementMap.containsKey(invokedInstance) || this.replacementMap.containsValue(invokedInstance));
    }
}

