/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;

public final class OrderedVerificationPhase
extends BaseVerificationPhase {
    private final int expectationCount;
    private int indexIncrement;

    OrderedVerificationPhase(@Nonnull RecordAndReplayExecution recordAndReplay, @Nonnull List<Expectation> expectationsInReplayOrder, @Nonnull List<Object> invocationInstancesInReplayOrder, @Nonnull List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay, new ArrayList<Expectation>(expectationsInReplayOrder), invocationInstancesInReplayOrder, invocationArgumentsInReplayOrder);
        this.discardExpectationsAndArgumentsAlreadyVerified();
        this.expectationCount = expectationsInReplayOrder.size();
        this.indexIncrement = 1;
    }

    private void discardExpectationsAndArgumentsAlreadyVerified() {
        for (VerifiedExpectation verified : this.recordAndReplay.executionState.verifiedExpectations) {
            int i = this.expectationsInReplayOrder.indexOf(verified.expectation);
            if (i < 0) continue;
            this.expectationsInReplayOrder.set(i, null);
        }
    }

    @Override
    @Nonnull
    protected List<ExpectedInvocation> findExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        Expectation expectation = this.expectationBeingVerified();
        int i = this.replayIndex;
        while (i >= 0 && i < this.expectationCount) {
            Expectation replayExpectation = (Expectation)this.expectationsInReplayOrder.get(i);
            Object replayInstance = this.invocationInstancesInReplayOrder.get(i);
            Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(i);
            i += this.indexIncrement;
            if (replayExpectation == null) continue;
            if (!this.matchInstance && this.recordAndReplay.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
                this.matchInstance = true;
            }
            if (!this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance, replayArgs)) continue;
            this.currentExpectation = replayExpectation;
            this.indexIncrement = 1;
            this.replayIndex = i += 1 - this.indexIncrement;
            if (expectation != null) {
                ++expectation.constraints.invocationCount;
            }
            this.mapNewInstanceToReplacementIfApplicable(mock);
            break;
        }
        return Collections.emptyList();
    }

    @Override
    void addVerifiedExpectation(@Nonnull Expectation expectation, @Nonnull Object[] args) {
        VerifiedExpectation verifiedExpectation = new VerifiedExpectation(expectation, args, this.argMatchers, this.replayIndex);
        this.addVerifiedExpectation(verifiedExpectation);
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Error errorThrown = this.pendingError;
        this.pendingError = null;
        if (errorThrown != null && minInvocations > 0) {
            throw errorThrown;
        }
        Expectation verifying = this.expectationBeingVerified();
        if (verifying == null) {
            return;
        }
        ExpectedInvocation invocation = verifying.invocation;
        this.argMatchers = invocation.arguments.getMatchers();
        int invocationCount = 1;
        while (this.replayIndex < this.expectationCount) {
            Expectation replayExpectation = (Expectation)this.expectationsInReplayOrder.get(this.replayIndex);
            if (replayExpectation != null && this.matchesCurrentVerification(invocation, replayExpectation)) {
                ++verifying.constraints.invocationCount;
                if (++invocationCount > maxInvocations) {
                    if (maxInvocations < 0) break;
                    throw replayExpectation.invocation.errorForUnexpectedInvocation();
                }
            } else if (invocationCount >= minInvocations) break;
            ++this.replayIndex;
        }
        this.argMatchers = null;
        int n = minInvocations - invocationCount;
        if (n > 0) {
            throw invocation.errorForMissingInvocations(n, Collections.emptyList());
        }
        this.verifyMaxInvocations(verifying, maxInvocations);
    }

    private boolean matchesCurrentVerification(@Nonnull ExpectedInvocation invocation, @Nonnull Expectation replayExpectation) {
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.arguments.getValues();
        this.matchInstance = invocation.matchInstance;
        if (this.recordAndReplay.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
            this.matchInstance = true;
        }
        Object replayInstance = this.invocationInstancesInReplayOrder.get(this.replayIndex);
        Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(this.replayIndex);
        return this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance, replayArgs);
    }

    private void verifyMaxInvocations(@Nonnull Expectation verifying, int maxInvocations) {
        int n;
        if (maxInvocations >= 0 && (n = verifying.constraints.invocationCount - maxInvocations) > 0) {
            Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(this.replayIndex - 1);
            throw verifying.invocation.errorForUnexpectedInvocations(replayArgs, n);
        }
    }

    @Override
    @Nullable
    protected Error endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        return super.endVerification();
    }

    @Override
    boolean shouldDiscardInformationAboutVerifiedInvocationOnceUsed() {
        return true;
    }
}

