/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.ReturnTypeConversion;
import mockit.internal.expectations.SequenceOfReturnValues;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResults;
import mockit.internal.util.TypeDescriptor;

final class Expectation {
    @Nullable
    final RecordPhase recordPhase;
    @Nonnull
    final ExpectedInvocation invocation;
    @Nonnull
    final InvocationConstraints constraints;
    @Nullable
    private InvocationResults results;
    boolean executedRealImplementation;

    Expectation(@Nonnull ExpectedInvocation invocation) {
        this.recordPhase = null;
        this.invocation = invocation;
        this.constraints = new InvocationConstraints(true);
    }

    Expectation(@Nullable RecordPhase recordPhase, @Nonnull ExpectedInvocation invocation, boolean nonStrict) {
        this.recordPhase = recordPhase;
        this.invocation = invocation;
        this.constraints = new InvocationConstraints(nonStrict);
    }

    @Nonnull
    InvocationResults getResults() {
        if (this.results == null) {
            this.results = new InvocationResults(this.invocation, this.constraints);
        }
        return this.results;
    }

    @Nullable
    Object produceResult(@Nullable Object invokedObject, @Nonnull Object[] invocationArgs) throws Throwable {
        if (this.results == null) {
            return this.invocation.getDefaultValueForReturnType();
        }
        return this.results.produceResult(invokedObject, invocationArgs);
    }

    @Nonnull
    Class<?> getReturnType() {
        String resolvedReturnType = this.invocation.getSignatureWithResolvedReturnType();
        return TypeDescriptor.getReturnType(resolvedReturnType);
    }

    void addSequenceOfReturnValues(@Nonnull Object[] values) {
        int n = values.length - 1;
        Object firstValue = values[0];
        Object[] remainingValues = new Object[n];
        System.arraycopy(values, 1, remainingValues, 0, n);
        InvocationResults sequence = this.getResults();
        if (!new SequenceOfReturnValues(this, firstValue, remainingValues).addResultWithSequenceOfValues()) {
            sequence.addReturnValue(firstValue);
            sequence.addReturnValues(remainingValues);
        }
    }

    void addResult(@Nullable Object value) {
        if (value == null) {
            this.getResults().addReturnValueResult(null);
        } else if (this.isReplacementInstance(value)) {
            if (this.recordPhase != null) {
                Map<Object, Object> replacementMap = this.recordPhase.getReplacementMap();
                replacementMap.put(this.invocation.instance, value);
            }
            this.invocation.replacementInstance = value;
        } else if (value instanceof Throwable) {
            this.getResults().addThrowable((Throwable)value);
        } else if (value instanceof Delegate) {
            this.getResults().addDelegatedResult((Delegate)value);
        } else {
            Class<?> rt = this.getReturnType();
            if (rt.isInstance(value)) {
                this.getResults().addReturnValueResult(value);
            } else {
                new ReturnTypeConversion(this, rt, value).addConvertedValue();
            }
        }
    }

    private boolean isReplacementInstance(@Nonnull Object value) {
        return this.invocation.isConstructor() && value.getClass().isInstance(this.invocation.instance);
    }

    @Nullable
    Error verifyConstraints(@Nonnull ExpectedInvocation replayInvocation, @Nonnull Object[] replayArgs, int minInvocations, int maxInvocations) {
        Error error = this.verifyConstraints(minInvocations);
        if (error != null) {
            return error;
        }
        return this.constraints.verifyUpperLimit(replayInvocation, replayArgs, maxInvocations);
    }

    @Nullable
    Error verifyConstraints(int minInvocations) {
        return this.constraints.verifyLowerLimit(this.invocation, minInvocations);
    }

    @Nullable
    Object executeRealImplementation(@Nonnull Object replacementInstance, @Nonnull Object[] args) throws Throwable {
        return this.getResults().executeRealImplementation(replacementInstance, args);
    }
}

