/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.classGeneration;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import mockit.asm.ClassReader;
import mockit.asm.ClassVisitor;
import mockit.internal.ClassFile;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;

public abstract class ImplementationClass<T> {
    @Nonnull
    protected final Class<?> sourceClass;
    @Nonnull
    protected String generatedClassName;

    protected ImplementationClass(@Nonnull Type mockedType) {
        this(Utilities.getClassType(mockedType));
    }

    protected ImplementationClass(@Nonnull Class<?> mockedClass) {
        this(mockedClass, GeneratedClasses.getNameForGeneratedClass(mockedClass, null));
    }

    protected ImplementationClass(@Nonnull Class<?> sourceClass, @Nonnull String desiredClassName) {
        this.sourceClass = sourceClass;
        this.generatedClassName = desiredClassName;
    }

    @Nonnull
    public final Class<T> generateClass() {
        ClassReader classReader = ClassFile.createReaderOrGetFromCache(this.sourceClass);
        ClassVisitor modifier = this.createMethodBodyGenerator(classReader.getBytecode());
        classReader.accept(modifier);
        return this.defineNewClass(modifier);
    }

    @Nonnull
    protected abstract ClassVisitor createMethodBodyGenerator(@Nonnull byte[] var1);

    @Nonnull
    private Class<T> defineNewClass(@Nonnull ClassVisitor modifier) {
        final ClassLoader parentLoader = ClassLoad.getClassLoaderWithAccess(this.sourceClass);
        final byte[] modifiedClassfile = modifier.toByteArray();
        try {
            Class<?> generatedClass = new ClassLoader(parentLoader){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    if (!name.equals(ImplementationClass.this.generatedClassName)) {
                        return parentLoader.loadClass(name);
                    }
                    return this.defineClass(name, modifiedClassfile, 0, modifiedClassfile.length);
                }
            }.findClass(this.generatedClassName);
            return generatedClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to define class: " + this.generatedClassName, e);
        }
    }
}

