/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Delegate;
import mockit.Expectations;
import mockit.MockUp;
import mockit.Verifications;
import mockit.internal.util.GeneratedClasses;

final class CapturedType {
    private static final ProtectionDomain JMOCKIT_DOMAIN = CapturedType.class.getProtectionDomain();
    @Nonnull
    final Class<?> baseType;

    CapturedType(@Nonnull Class<?> baseType) {
        this.baseType = baseType;
    }

    boolean isToBeCaptured(@Nonnull Class<?> aClass) {
        if (aClass == this.baseType || aClass.isArray() || !this.baseType.isAssignableFrom(aClass) || Proxy.isProxyClass(aClass) || CapturedType.extendsJMockitBaseType(aClass)) {
            return false;
        }
        return !aClass.isInterface() && !CapturedType.isNotToBeCaptured(aClass.getClassLoader(), aClass.getProtectionDomain(), aClass.getName());
    }

    private static boolean extendsJMockitBaseType(@Nonnull Class<?> aClass) {
        return MockUp.class.isAssignableFrom(aClass) || Expectations.class.isAssignableFrom(aClass) || Verifications.class.isAssignableFrom(aClass) || Delegate.class.isAssignableFrom(aClass);
    }

    static boolean isNotToBeCaptured(@Nullable ClassLoader loader, @Nullable ProtectionDomain pd, @Nonnull String classNameOrDesc) {
        if (loader == null && (classNameOrDesc.startsWith("java") || classNameOrDesc.startsWith("jdk/")) || pd == JMOCKIT_DOMAIN || GeneratedClasses.isGeneratedClass(classNameOrDesc)) {
            return true;
        }
        return classNameOrDesc.endsWith("Test") || classNameOrDesc.startsWith("junit") || classNameOrDesc.startsWith("sun") && !CapturedType.hasSubPackage(classNameOrDesc, 4, "management") || classNameOrDesc.startsWith("org") && CapturedType.hasSubPackage(classNameOrDesc, 4, "junit testng hamcrest gradle") || classNameOrDesc.startsWith("com") && (CapturedType.hasSubPackage(classNameOrDesc, 4, "sun") && !CapturedType.hasSubPackage(classNameOrDesc, 8, "proxy org") || CapturedType.hasSubPackage(classNameOrDesc, 4, "intellij")) || GeneratedClasses.isExternallyGeneratedSubclass(classNameOrDesc);
    }

    private static boolean hasSubPackage(@Nonnull String nameOrDesc, int offset, @Nonnull String subPackages) {
        int subPackageEnd;
        int subPackageStart = 0;
        do {
            int subPackageLength;
            if (nameOrDesc.regionMatches(offset, subPackages, subPackageStart, subPackageLength = ((subPackageEnd = subPackages.indexOf(32, subPackageStart)) > 0 ? subPackageEnd : subPackages.length()) - subPackageStart)) {
                return true;
            }
            subPackageStart = subPackageEnd + 1;
        } while (subPackageEnd > 0);
        return false;
    }
}

