/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.ClassMetadataReader;
import mockit.asm.ClassReader;
import mockit.asm.ClassVisitor;
import mockit.asm.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.ClassIdentification;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.capturing.CapturedType;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.VisitInterruptedException;

public final class CaptureTransformer<M>
implements ClassFileTransformer {
    @Nonnull
    private final CapturedType capturedType;
    @Nonnull
    private final String capturedTypeDesc;
    @Nonnull
    private final CaptureOfImplementations<M> captureOfImplementations;
    @Nonnull
    private final Map<ClassIdentification, byte[]> transformedClasses;
    @Nonnull
    private final Map<String, Boolean> superTypesSearched;
    @Nullable
    private final M typeMetadata;
    private boolean inactive;

    CaptureTransformer(@Nonnull CapturedType capturedType, @Nonnull CaptureOfImplementations<M> captureOfImplementations, boolean registerTransformedClasses, @Nullable M typeMetadata) {
        this.capturedType = capturedType;
        this.capturedTypeDesc = JavaType.getInternalName(capturedType.baseType);
        this.captureOfImplementations = captureOfImplementations;
        this.transformedClasses = registerTransformedClasses ? new HashMap(2) : Collections.emptyMap();
        this.superTypesSearched = new HashMap<String, Boolean>();
        this.typeMetadata = typeMetadata;
    }

    public void deactivate() {
        this.inactive = true;
        if (!this.transformedClasses.isEmpty()) {
            for (Map.Entry<ClassIdentification, byte[]> classNameAndOriginalBytecode : this.transformedClasses.entrySet()) {
                ClassIdentification classId = classNameAndOriginalBytecode.getKey();
                byte[] originalBytecode = classNameAndOriginalBytecode.getValue();
                Startup.redefineMethods(classId, originalBytecode);
            }
            this.transformedClasses.clear();
        }
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String classDesc, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
        block3: {
            if (classBeingRedefined != null || this.inactive || CapturedType.isNotToBeCaptured(loader, protectionDomain, classDesc)) {
                return null;
            }
            SuperTypeCollector superTypeCollector = new SuperTypeCollector(loader);
            ClassMetadataReader cmr = new ClassMetadataReader(classfileBuffer);
            try {
                superTypeCollector.visit(cmr);
            }
            catch (VisitInterruptedException ignore) {
                if (!superTypeCollector.classExtendsCapturedType) break block3;
                String className = classDesc.replace('/', '.');
                ClassReader cr = new ClassReader(classfileBuffer);
                return this.modifyAndRegisterClass(loader, className, cr);
            }
        }
        return null;
    }

    @Nonnull
    private byte[] modifyAndRegisterClass(@Nullable ClassLoader loader, @Nonnull String className, @Nonnull ClassReader cr) {
        BaseClassModifier modifier = this.captureOfImplementations.createModifier(loader, cr, this.capturedType.baseType, this.typeMetadata);
        cr.accept(modifier);
        ClassIdentification classId = new ClassIdentification(loader, className);
        byte[] originalBytecode = cr.getBytecode();
        if (this.transformedClasses == Collections.emptyMap()) {
            TestRun.mockFixture().addTransformedClass(classId, originalBytecode);
        } else {
            this.transformedClasses.put(classId, originalBytecode);
        }
        TestRun.mockFixture().registerMockedClass(this.capturedType.baseType);
        return ((ClassVisitor)modifier).toByteArray();
    }

    @Nullable
    public <C extends CaptureOfImplementations<?>> C getCaptureOfImplementationsIfApplicable(@Nonnull Class<?> aType) {
        if (this.capturedType.baseType.isAssignableFrom(aType) && this.typeMetadata != null) {
            return (C)this.captureOfImplementations;
        }
        return null;
    }

    public boolean areCapturedClasses(@Nonnull Class<?> mockedClass1, @Nonnull Class<?> mockedClass2) {
        Class<?> baseType = this.capturedType.baseType;
        return baseType.isAssignableFrom(mockedClass1) && baseType.isAssignableFrom(mockedClass2);
    }

    private final class SuperTypeCollector {
        @Nullable
        private final ClassLoader loader;
        boolean classExtendsCapturedType;

        SuperTypeCollector(ClassLoader loader) {
            this.loader = loader;
        }

        void visit(@Nonnull ClassMetadataReader cmr) {
            this.classExtendsCapturedType = false;
            String superName = cmr.getSuperClass();
            if (CaptureTransformer.this.capturedTypeDesc.equals(superName)) {
                this.classExtendsCapturedType = true;
                throw VisitInterruptedException.INSTANCE;
            }
            String[] interfaces = cmr.getInterfaces();
            if (interfaces != null) {
                this.interruptVisitIfClassImplementsAnInterface(interfaces);
            }
            if (superName != null) {
                this.searchSuperTypes(superName, interfaces);
            }
            throw VisitInterruptedException.INSTANCE;
        }

        private void interruptVisitIfClassImplementsAnInterface(@Nonnull String[] interfaces) {
            for (String implementedInterface : interfaces) {
                if (!CaptureTransformer.this.capturedTypeDesc.equals(implementedInterface)) continue;
                this.classExtendsCapturedType = true;
                throw VisitInterruptedException.INSTANCE;
            }
        }

        private void searchSuperTypes(@Nonnull String superName, @Nullable String[] interfaces) {
            if (!"java/lang/Object".equals(superName) && !superName.startsWith("mockit/")) {
                this.searchSuperType(superName);
            }
            if (interfaces != null && interfaces.length > 0) {
                for (String itf : interfaces) {
                    if (itf.startsWith("java/") || itf.startsWith("javax/")) continue;
                    this.searchSuperType(itf);
                }
            }
        }

        private void searchSuperType(@Nonnull String superName) {
            block4: {
                Boolean extendsCapturedType = (Boolean)CaptureTransformer.this.superTypesSearched.get(superName);
                if (extendsCapturedType == Boolean.FALSE) {
                    return;
                }
                if (extendsCapturedType == Boolean.TRUE) {
                    this.classExtendsCapturedType = true;
                    throw VisitInterruptedException.INSTANCE;
                }
                byte[] classfileBytes = ClassFile.getClassFile(this.loader, superName);
                ClassMetadataReader cmr = new ClassMetadataReader(classfileBytes);
                try {
                    this.visit(cmr);
                }
                catch (VisitInterruptedException e) {
                    CaptureTransformer.this.superTypesSearched.put(superName, this.classExtendsCapturedType);
                    if (!this.classExtendsCapturedType) break block4;
                    throw e;
                }
            }
        }
    }
}

